% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{model-variable-selection}
\alias{model-variable-selection}
\alias{vars_prms}
\alias{vars_data}
\alias{vars_eta}
\alias{vars_nm_std}
\alias{vars_starts_with}
\alias{vars_matches}
\title{Selecting model variables}
\usage{
vars_prms(vars)

vars_data(vars)

vars_eta(vars)

vars_nm_std(vars)

vars_starts_with(match, vars)

vars_matches(match, vars)
}
\arguments{
\item{vars}{A character vector of variable names (taken from the selection context)}

\item{match}{A character vector to match against}
}
\value{
A selection context
}
\description{
The output task allows to select model variables using
a concise mini language. You can select variables by
name or using one of the helper functions described below.
\subsection{Overview of selection features}{

The selection of variables builds on the tidyselect package
which implements a powerful variable selection language (see \link[tidyselect:language]{tidyselect::language}).
The following features are most relevant for the
selection of model variables:
\itemize{
\item \code{|} for selecting the union of several variables
\item \code{c()}  for combining selections
\item \code{!} for taking the complement of a set of variables
}

In addition, you can select variables using a combination of the following helper functions:
\itemize{
\item \code{vars_prms()} selects all model parameters
\item \code{vars_data()} selects all data defined variables
\item \code{vars_eta()} selects all eta variables
\item \code{vars_nm_std()} selects the standard NONMEM variables DV, PRED, RES, WRES, IPREDI, IWRESI
\item \code{vars_starts_with()} selects variables that start with a prefix
\item \code{vars_matches()} selects variables that match a regular expression
}
}
}
\examples{

m <- model() +
  input_variable("dose") +
  prm_log_normal("emax", median = 10, var_log = 0.09) +
  prm_log_normal("ed50", median = 50, var_log = 0.09) +
  algebraic(effect~emax*dose/(ed50 + dose)) +
  obs_proportional(~effect, var_prop = 1)

# output all model parameter and eta variables
render(m, tasks = tsk_output("prms", variables = vars_prms() | vars_eta()))
}
