% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-special-string.R, R/is-special-string.R
\name{assert_all_are_numeric_strings}
\alias{assert_all_are_logical_strings}
\alias{assert_all_are_numeric_strings}
\alias{assert_any_are_logical_strings}
\alias{assert_any_are_numeric_strings}
\alias{is_logical_string}
\alias{is_numeric_string}
\title{Does the string contain a number/logical value?}
\usage{
assert_all_are_numeric_strings(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_numeric_strings(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_logical_strings(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_logical_strings(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_numeric_string(x, .xname)

is_logical_string(x, .xname)
}
\arguments{
\item{x}{A character vector.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_numeric_string} returns a logical vector that is \code{TRUE}
when the string contains numbers.  The corresponding \code{assert_*} 
functions return nothing but throw an error on failure.
}
\description{
Check to see if a character vector contains numeric/logical strings.
}
\examples{
is_numeric_string(c("1", "1.1", "-1.1e1", "one", NA))
# R only treats certain capitalizations of "true" and "false" as logical
x <- c(
  "TRUE", "FALSE", "true", "false", "True", "False", "trUE", "FaLsE", 
  "T", "F", "t", "f"
)
is_logical_string(x)

assert_all_are_numeric_strings(c("1", "2.3", "-4.5", "6e7", "8E-9"))
assert_any_are_numeric_strings(c("1", "Not a number"))
}

