% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predicates.R
\name{not_na}
\alias{not_na}
\title{Returns TRUE if value is not NA}
\usage{
not_na(x, allow.NaN = FALSE)
}
\arguments{
\item{x}{A R object that supports \link{is.na} an \link{is.nan}}

\item{allow.NaN}{A logical indicating whether NaNs should be allowed
(default FALSE)}
}
\value{
A vector of the same length that is TRUE when the element is
not NA and FALSE otherwise
}
\description{
This is the inverse of \code{\link[base]{is.na}}. This is a convenience
function meant to be used as a predicate in an \code{\link{assertr}}
assertion.
}
\examples{
not_na(NA)
not_na(2.8)
not_na("tree")
not_na(c(1, 2, NA, 4))
}
\seealso{
\code{\link{is.na}} \code{\link{is.nan}}
}

