% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.X.R
\name{assign.X}
\alias{assign.X}
\title{Perform a population assignment test on unknown individuals using known data}
\usage{
assign.X(x1, x2, dir = NULL, scaled = F, pca.method = "mixed",
  pca.PCs = "kaiser-guttman", pca.loadings = F, model = "svm",
  svm.kernel = "linear", svm.cost = 1, ntree = 50, ...)
}
\arguments{
\item{x1}{An input object containing data from known individuals for building predictive models. It could be a list object returned from the function read.genpop(), reduce.allele() or compile.data(). Or, it could be a data frame containing non-genetic data returned from read.csv() or read.table().}

\item{x2}{An input object containing data from unknown individuals to be predicted. It could be a list object returned from read.genpop(), reduce.allele(), or compile.data(). Or, it could be a data frame containing non-genetic data returned from read.csv() or read.table(). The x1 and x2 should be the same type (both are either lists or data frames).}

\item{dir}{A character string to specify the folder name for saving output files. A slash at the end must be included (e.g., dir="YourFolderName/"). Otherwise, the files will be saved under your working directory.}

\item{scaled}{A logical variable (TRUE or FALSE) to specify whether to center (make mean of each feature to 0) and scale (make standard deviation of each feature to 1) the dataset before performing PCA and cross-validation. Default is FALSE. As genetic data has converted to numeric data between 0 and 1, to scale or not to scale the genetic data should not be critical. However, it is recommended to set scaled=TRUE when integrated data contains various scales of features.}

\item{pca.method}{Either a character string ("mixed", "independent", or "original") or logical variable (TRUE or FALSE) to specify how to perform PCA on non-genetic data (PCA is always performed on genetic data). The character strings are used when analyzing integrated (genetic plus non-genetic) data. If using "mixed" (default), PCA is perfromed across the genetic and non-genetic data, resulting in each PC summarizing mixed variations of genetic and non-genetic data. If using "independent", PCA is independently performed on non-genetic data. Genetic PCs and non-genetic PCs are then used as new features. If using "original", original non-genetic data and genetic PCs are used as features. The logical variable is used when analyzing non-genetic data.If TRUE, it performs PCA on the training data and applys the loadings to the test data. Scores of training and test data will be used as new features.}

\item{pca.PCs}{A criterion to retain number of PCs. By default, it uses Kaiser-Guttman criterion that any PC has the eigenvalue greater than 1 will be retained as the new variable/feature. Users can set an integer to specify the number of PCs to be retained.}

\item{pca.loadings}{A logical variable (TRUE or FALSE) to determine whether to output the loadings of training data to text files. Default is FALSE. Just a heads-up, the output files could take some storage space, if set TRUE.}

\item{model}{A character string to specify which classifier to use for creating predictive models. The current options include "lda", "svm", "naiveBayes", "tree", and "randomForest". Default is "svm"(support vector machine).}

\item{svm.kernel}{A character string to specify which kernel to be used when using "svm" classifier.}

\item{svm.cost}{A number to specify the cost for "svm" method.}

\item{ntree}{A integer to specify how many trees to build when using "randomForest" method.}

\item{...}{Other arguments that could be potentially used for various models}
}
\value{
This function outputs assignment results and other analytical information in text files that will be saved under your designated folder. It also outputs a membership probability plot, if permitted.
}
\description{
This function assigns unknown individuals to possible source populations based on known individuals and genetic or non-genetic or integrated data.
}

