% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async.r, R/pump.r
\name{async}
\alias{async}
\alias{await}
\alias{with_prefix}
\title{Create an asynchronous task from sequential code.}
\usage{
async(expr, ..., split_pipes = TRUE, trace = trace_)

await(prom)

with_prefix(prefix)
}
\arguments{
\item{expr}{An expression, to be executed asynchronously.}

\item{...}{Undocumented.}

\item{split_pipes}{Rewrite chained calls that use \code{await}
(see below)}

\item{trace}{Enable verbose logging by passing a function to
\code{trace}, like \code{async(trace=cat, {...})}. \code{trace} should take a
character argument. Helper \code{with_prefix} makes a function that
prints a message with the given prefix. You can also say something
like \code{trace=browser} for "single stepping" through an async.}

\item{prom}{A promise, or something that can be converted to such
by \code{\link[promises:is.promise]{promises::as.promise()}}.}

\item{prefix}{Character prefix to print before the trace.}
}
\value{
\code{async()} returns an object with class "promise" as
described by the \link{promises} package (i.e. not the promises used
in R's lazy evaluation.)

In the context of an \code{async}, \code{await(x)} returns the resolved value of
a promise \code{x}, or stops with an error.
}
\description{
\code{async({...})}, with an expression written in its argument, allows
that expression to be evaluated in an asynchronous, or non-blocking
manner. \code{async} returns an object with class \code{c("async", "promise")} which
implements the \link[promises:promise]{promise} interface.
}
\details{
An example Shiny app using \code{async/await} is on Github:
\url{https://github.com/crowding/cranwhales-await}

When an \code{async} object is activated, it will evaluate its expression
until it reaches the keyword \code{await}. The \code{async} object will return
to its caller and preserve the partial state of its evaluation.
When the awaited value is resolved, evaluation continues from where
the \code{async} left off.

When an async block finishes (either by reaching the end, or using
\code{return()}), the promise resolves with the resulting value. If the
async block stops with an error, the promise is rejected with
that error.

The syntax rules for an \code{async} are analogous to those for \code{\link[=gen]{gen()}};
\code{await} must appear only within the arguments of functions for
which there is a pausable implementation (See \verb{[pausables()]}). By
default \code{split_pipes=TRUE} is enabled and this will reorder some
expressions to satisfy this requirement.

Async blocks and generators are conceptually related and share much
of the same underlying mechanism. You can think of one as "output"
and the other as "input". A generator pauses until a value is
requested, runs until it has a value to output, then pauses again.
An async runs until it requires an external value, pauses until
it receives the value, then continues.

When \code{split_pipes=FALSE}, \code{await()} can only appear in the
arguments of \link{pausables} and not ordinary R functions.
This is a inconvenience as it prevents using \code{await()} in a
pipeline. \code{async} by default has \code{split_pipes=TRUE} which enables
some syntactic sugar: if an \code{await()} appears in the leftmost,
unnamed, argument of an R function, the pipe will be "split" at
that call using a temporary variable. For instance,\preformatted{async(makeRequest() |> await() |> sort())
}

will be effectively rewritten to something like\preformatted{async(\{.tmp <- await(makeRequest()); sort(.tmp)\})
}

This works only so long as \code{await} appears in
calls that evaluate their leftmost arguments
normally. \code{split_pipes} can backfire if the outer call has other
side effects; for instance \code{suppressWarnings(await(x))} will be
rewritten as \code{{.tmp <- await(x); suppressWarnings(x)}}, which
would defeat the purpose.
}
\examples{
myAsync <- async(for (i in 1:4) {
  await(delay(5))
  cat(i, "\n")
}, trace=with_prefix("myAsync"))

}
