% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atable.R
\name{atable}
\alias{atable}
\alias{atable.data.frame}
\alias{atable.formula}
\title{Create Tables for Reporting of Clinical Trials}
\usage{
atable(x, ...)

\method{atable}{data.frame}(
  x,
  target_cols,
  group_col = NULL,
  split_cols = NULL,
  format_to = atable_options("format_to"),
  drop_levels = TRUE,
  add_levels_for_NA = FALSE,
  blocks = NULL,
  ...
)

\method{atable}{formula}(formula, data, ...)
}
\arguments{
\item{x}{An object. If \code{x} is a data.frame, it must have unique and syntactically valid colnames,
see \code{\link[atable]{is_syntactically_valid_name}}. If \code{x} is a formula, then its format must
be \code{target_cols ~ group_col | split_cols}. See other arguments for more details.}

\item{...}{Passed from and to other methods. You can use the ellipsis ... to modify atable:
For example the default-statistics for numeric variables are mean and sd. To change these statistics pass
a function to argument \code{statistics.numeric}, that calculates the statistics you prefer for your data.

See examples below how to modify atable by ... .

Actually \code{statistics.numeric} is passed to \code{\link{statistics}} and thus documented there,
but for convenience it also documented here.

Here is a list of the statistics and hypothesis tests that can be modfied by \code{...} :
\itemize{
  \item{\code{statistics.numeric}}{: Either \code{NULL} or a function. Default is \code{NULL}.
  If a function, then it will replace \code{atable:::statistics.numeric} when atable is called.
  The function must mimic \code{\link{statistics}}: see the help there.}

  \item{\code{statistics.factor}}{: Analog to argument statistics.numeric.}

  \item{\code{statistics.ordered}}{: Analog to argument statistics.numeric.}

  \item{\code{two_sample_htest.numeric}}{: Either \code{NULL} or a function. Default is \code{NULL}.
  If a function, then it will replace \code{atable:::two_sample_htest.numeric} when atable is called.
  The function must mimic \code{\link{two_sample_htest}}: see the help there.}

  \item{\code{two_sample_htest.factor}}{: Analog to argument two_sample_htest.numeric}

  \item{\code{two_sample_htest.ordered}}{: Analog to argument two_sample_htest.numeric}


  \item{\code{multi_sample_htest.numeric}}{: Either \code{NULL} or a function. Default is \code{NULL}.
  If a function, then it will replace \code{atable:::multi_sample_htest.numeric} when atable is called.
  The function must mimic \code{\link{multi_sample_htest}}: see the help there.}

  \item{\code{multi_sample_htest.factor}}{: Analog to argument multi_sample_htest.numeric}

  \item{\code{multi_sample_htest.ordered}}{: Analog to argument multi_sample_htest.numeric}

  \item{\code{format_statistics.statistics_numeric}}{: Either \code{NULL} or a function. Default is \code{NULL}.
  If a function, then it will replace \code{atable:::format_statistics.statistics_numeric}.
  The function must mimic \code{\link{format_statistics}}: see the help there.}

  \item{\code{format_statistics.statistics_factor}}{: Analog to argument format_statistics.statistics_numeric}

  \item{\code{format_tests.htest}}{: Either \code{NULL} or a function. Default is \code{NULL}.
  If a function, then it will replace \code{format_tests.htest}.
  The function must mimic \code{\link{format_tests}}: see the help there.}

  \item{\code{format_tests.htest_with_effect_size}}{: Analog to argument format_tests.htest}



 }}

\item{target_cols}{A character vector containing some column names of \code{x}.

Descriptive statistics and hypothesis test are applied to these columns depending on their class.
The descriptive statistics are defined by \code{\link{statistics}};
their representation and format by \code{\link{format_statistics}}.

Hypothesis test are defined by \code{\link{two_sample_htest}} or \code{\link{multi_sample_htest}}
(depending on the number of levels of \code{group_col});
their representation and format by \code{\link{format_tests}}.
Note that atable always adds one name to \code{target_cols} to count the number of obsservations.
This name is stored in \code{atable_options('colname_for_observations')}.}

\item{group_col}{A character of length 1 containing a column of \code{x} or \code{NULL}.
This column defines the groups that are compared by the hypothesis tests.
\code{\link[base:factor]{as.factor}} is applied to this column before further processing.
Default is \code{NULL}, meaning that no hypothesis tests are applied.}

\item{split_cols}{A character vector containing some of \code{colnames(x)} or \code{NULL}.
\code{x} is splitted by these columns before descriptive statistics and hypothesis test are applied.
\code{\link[base:factor]{as.factor}} is applied to this column before further processing.
Default is \code{NULL}, meaning that no splitting is done.}

\item{format_to}{A character vector of length 1. Specifies the format of the output of \code{atable}.
Possible values are \code{'Latex'}, \code{'Word'}, \code{'Raw'}, \code{'HTML'}, \code{'Console'},
\code{'markdown'}, \code{'md'}.
Default is defined in \code{\link{atable_options}}.}

\item{drop_levels}{A logical. If \code{TRUE} then \code{\link[base]{droplevels}} is called on \code{group_col}
and \code{split_cols} beforefurther processsing. Default is \code{TRUE}.}

\item{add_levels_for_NA}{If \code{TRUE} then \code{\link[base:factor]{addNA}} is called on \code{group_col} and
\code{split_cols} before further processsing. Default is \code{FALSE}.}

\item{blocks}{\code{NULL} or a list. If blocks is a list, then the names of the list must be non-NA characters.
The elements of the list must be some of \code{target_cols}, retaining the order of \code{target_cols}.
Also in this case \code{split_cols} must be \code{NULL} as simultaneous blocking and splitting is not supported.
Default is \code{NULL}, meaning that no blocking is done. Variables of a block are additionally indented.
Blocking has no effect on the statistics, it only affects the indentation of the resulting table. See Examples.}

\item{formula}{A formula of the form \code{target_cols ~ group_col | split_cols}.
The \code{|} separates the \code{group_col} from the \code{split_cols}.
Read the \code{|} as 'given' as in a conditional probability \code{P(target_cols | split_cols)}.
\code{target_cols} and \code{split_cols} may contain multiple names separated by \code{+}.
\code{group_col} must be a single name if given.
\code{group_col} and \code{split_cols} may be omitted and can be replaced by \code{1} in this case.
The \code{|} may also be omitted if no \code{split_cols} are given.}

\item{data}{Passed to \code{atable(x = data, ...)}.}
}
\value{
Results depend on \code{format_to}:
\itemize{
\item{\code{'Raw'}: }{A list with two elemtents called \code{'statistics_result'} and \code{'tests_result'}, that
contain all results of the descriptve statistics and the hypothesis tests.
This format useful, when extracting a specific result unformated
 (when \code{format_to} is not \code{'Raw'} all numbers are also returned, but as rounded
 characters for printing and squeezed into a data.frame).
\itemize{
 \item{\code{'statistics_result'}: } { contains a data.frame with colnames \code{c(split_cols, group_col, target_cols}.
 \code{split_cols} and \code{group_col} retain their original values (now as factor).
 \code{target_cols} contain lists with the results of function \code{\link{statistics}}.
 As the result of function \code{statistics} is also a list, \code{target_cols} contain lists of lists.}

   \item {\code{'tests_result'}: } {has the same structure as \code{'statistics_result'}, but contains the results
 of \code{\link{two_sample_htest}} and \code{\link{multi_sample_htest}}.
 Note that \code{tests_result} only exists if \code{split_cols} is not \code{NULL}.}}
}
\item{\code{'Word'}: }{A data.frame.
Column \code{atable_options('colname_for_group')} contains
all combinations of the levels of \code{split_cols} and
the names of the results of function \code{\link{format_statistics}}.

Further columns are the levels of \code{group_col} the names of the results of \code{format_tests}.

The levels of \code{split_cols} and the statistics are arranged vertically.
The hypothesis test are arranged horizontally.

}
\item{\code{'HTML'}: }{Same as for \code{format_to = 'Word'} but a different character indents
the first column.}
#' \item{\code{'Console'}: }{Meant for printing in the R console for interactive analysis.
Same as for \code{format_to = 'Word'} but a different character indents the first column.}
\item{\code{'Latex'}: }{Same as for \code{format_to = 'Word'} but a different character indents
the first column and with \code{\link{translate_to_LaTeX}} applied afterwards. }
}
}
\description{
Applies descriptive statistics and hypothesis tests to data, and arranges the results for printing.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: applies descriptive statistics and hypothesis tests, arranges the results for printing.

\item \code{formula}: parses the formula and passes its parts to \code{atable}.
}}

\examples{
# See vignette for more examples:
# utils::vignette('atable_usage', package = 'atable')

# Analyse datasets::ToothGrowth:
# Length of tooth for each dose level and delivery method:
atable::atable(datasets::ToothGrowth,
  target_cols = 'len',
  group_col = 'supp',
  split_cols = 'dose',
  format_to = 'Word')
# Print in .docx with e.g. flextable::regulartable and officer::body_add_table

# Analyse datasets::ChickWeight:
# Weight of chickens for each time point and diet:
atable(weight ~ Diet | Time, datasets::ChickWeight, format_to = 'Latex')
# Print as .pdf with e.g. Hmisc::latex

# Analyse atable::test_data:
atable(Numeric + Logical + Factor + Ordered ~ Group | Split1 + Split2,
  atable::test_data, format_to = 'HTML')
# Print as .html with e.g. knitr::kable and options(knitr.kable.NA = '')

# Modify atable: calculate median and MAD for numeric variables
new_stats  <- function(x, ...){list(Median = median(x, na.rm = TRUE),
                                    MAD = mad(x, na.rm = TRUE))}
atable(atable::test_data,
       target_cols = c('Numeric', 'Numeric2'),
       statistics.numeric = new_stats,
       format_to = 'Console')
# Print in Console with format_to = 'Console'.

# Analyse mtcars and add labels and units of via package Hmisc
mtcars <- within(datasets::mtcars, {gear <- factor(gear)})
# Add labels and units.
attr(mtcars$mpg, 'alias') = 'Consumption [Miles (US)/ gallon]'
Hmisc::label(mtcars$qsec) = 'Quarter Mile Time'
units(mtcars$qsec) = 's'

# apply atable
atable::atable(mpg + hp + gear + qsec ~ cyl | vs,
               mtcars,
               format_to = 'Console')

# Blocks
# In datasets::mtcars the variables cyl, disp and mpg are related to the engine and am and gear are
# related to the gearbox. So grouping them together is desireable.
atable::atable(datasets::mtcars,
               target_cols = c("cyl", "disp", "hp", "am", "gear", "qsec") ,
               blocks = list("Engine" = c("cyl", "disp", "hp"),
                             "Gearbox" = c("am", "gear")),
               format_to = "Console")
# Note that Variable qsec is not blocked and thus not indented.
}
