% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flip-layers.R
\name{flip_layers}
\alias{flip_layers}
\title{Flip layers for visualization.}
\usage{
flip_layers(data)
}
\arguments{
\item{data}{dataframe with columns polygon and layer. layer id is based on
atlantis output (0 = layer closest to the sediment)}
}
\value{
dataframe with flipped layerids. 1 = surface.
}
\description{
Within Atlantis the water column id 0 is the water column closest to the sediment.
In order to simplify graphical interpretation of vertical plots this order
is reversed. The surface layer is 1 by default. The sediment layer id is equal
to the number of total layers. Please note that this is only used for graphical
display.
}
\examples{
data <- rbind(expand.grid(species = "sp1", polygon = 0, layer = 0:7),
              expand.grid(species = "sp1", polygon = 1, layer = 0:4),
              expand.grid(species = "sp1", polygon = 2, layer = 0:2),
              expand.grid(species = "sp1", polygon = 3, layer = c(0:3, 7)))
data$atoutput <- runif(nrow(data), min = 0, max = 2)
flip_layers(data)
}
