% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotACF.R
\name{plotACF}
\alias{plotACF}
\title{Autocorrelation Function Plot}
\usage{
plotACF(object, ..., variable = NULL, alpha = 0.95)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{...}{Other modelAudit objects to be plotted together.}

\item{variable}{Name of model variable to order residuals. If value is NULL data order is taken. If value is "Predicted response" or "Fitted values" then data is ordered by fitted values. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}

\item{alpha}{Confidence level of the interval.}
}
\description{
Plot Autocorrelation Function of models residuals.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotACF(lm_au)

library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotACF(lm_au, rf_au)


}
