% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResidualDensity.R
\name{plotResidualDensity}
\alias{plotResidualDensity}
\title{Residual Density Plot}
\usage{
plotResidualDensity(object, ..., split.var = TRUE, variable = NULL)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{...}{Other modelAudit objects to be plotted together.}

\item{split.var}{Logical. Indicates whenever plot should be splitted by variable.}

\item{variable}{variable name o split. Optional. Should be provided  only for modelAudit object.}
}
\value{
ggplot object
}
\description{
Density of model residuals.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotResidualDensity(lm_au)

library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotResidualDensity(lm_au, rf_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
