% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{audit}
\alias{audit}
\title{Create modelAudit object}
\usage{
audit(object, data = NULL, y = NULL, predict.function = yhat,
  residual.function = NULL, label = NULL)
}
\arguments{
\item{object}{An object containing a model or object of class explainer (see \code{\link[DALEX]{explain}}).}

\item{data}{Data.frame or matrix - data that will be used by further validation functions. If not provided, will be extracted from the model.}

\item{y}{Response vector that will be used by further validation functions. Some functions may require an integer vector containing binary labels with values 0,1.  If not provided, will be extracted from the model.}

\item{predict.function}{Function that takes two arguments: model and data. It should return a numeric vector with predictions.}

\item{residual.function}{Function that takes three arguments: model, data and response vector. It should return a numeric vector with model residuals for given data. If not provided, response residuals (\eqn{y-\hat{y}}) are calculated.}

\item{label}{Character - the name of the model. By default it's extracted from the 'class' attribute of the model.}
}
\value{
An object of class ModelAudit, which contains:
#' \itemize{
\item \code{model.class} class of the audited model,
\item \code{label} the name of the model,
\item \code{model} the audited model,
\item \code{fitted.values} fitted values from model,
\item \code{data} data used for fitting the model,
\item \code{y} vector with values of predicted variable used for fitting the model,
\item \code{predict.function} function that were used for model predictions,
\item \code{residual.function} function that were used for calculating model residuals,
\item \code{residuals}
\item \code{std.residuals} standardized residuals - the residuals divided by theirs standard deviation.
}
}
\description{
Function \code{audit} create modelAudit object for further validation of a model.
Models may have very different structures. This function creates a unified representation of a model and calculates residuals,
which can be further processed by various error analysis functions.
}
\examples{
library(MASS)
model.glm <- glm(Postwt ~ Prewt + Treat + offset(Prewt), family = gaussian, data = anorexia)
audit.glm <- audit(model.glm)

p.fun <- function(model, data){predict(model, data, response = "link")}
audit.glm.newpred <- audit(model.glm, predict.function = p.fun)


library(randomForest)
model.rf <- randomForest(Species ~ ., data=iris)
audit.rf <- audit(model.rf)

}
