% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorePeak.R
\name{scorePeak}
\alias{scorePeak}
\title{Peak Score}
\usage{
scorePeak(object, variable = NULL)
}
\arguments{
\item{object}{Object An object of class modelAudit or modelResidual.}

\item{variable}{Name of model variable to order residuals. If value is NULL data order is taken. If value is "Predicted response" or "Fitted values" then data is ordered by fitted values. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}
}
\value{
an object of class scoreAudit
}
\description{
This score is calculated on the basis of Peak test, which is used for checking for homoscedasticity of residuals in regression analyses.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
scorePeak(lm_au)

}
