% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{extract_params.glm}
\alias{extract_params.glm}
\title{extract_params.glm}
\usage{
\method{extract_params}{glm}(object, ...)
}
\arguments{
\item{object}{an object of class "glm"}

\item{...}{further arguments passed to or from other methods}
}
\value{
PFA as a list-of-lists that can be inserted into a cell or pool
}
\description{
Extract generalized linear model parameters from the glm library
}
\examples{
X1 <- rnorm(100)
X2 <- runif(100)
Y <- 3 - 5 * X1 + 3 * X2 + rnorm(100, 0, 3)
Y <- Y > 0

glm_model <- glm(Y ~ X1 + X2, family = binomial(logit))
model_params <- extract_params(glm_model)
}
