% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{shinyAppAuth0}
\alias{shinyAppAuth0}
\title{Create a Shiny app object with Auth0 Authentication}
\usage{
shinyAppAuth0(ui, server, config_file = NULL, ...)
}
\arguments{
\item{ui}{an ordinary UI object to create shiny apps.}

\item{server}{an ordinary server object to create shiny apps.}

\item{config_file}{path to YAML configuration file.}

\item{...}{Other arguments passed on to \code{\link[shiny:shinyApp]{shiny::shinyApp()}}.}
}
\description{
This function modifies ui and server objects to run using Auth0
authentication.
}
\details{
You can also use a diferent configuration file by setting the
\code{auth0_config_file} option with:
\code{options(auth0_config_file = "path/to/file.yaml")}.
}
\section{Disable auth0 while developing apps}{


Sometimes, using auth0 to develop and test apps can be frustrating,
because every time the app is started, auth0 requires the user to log-in.
To avoid this problem, one can run \code{options(auth0_disable = TRUE)} to
disable auth0 temporarily.
}

