% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_class_functions.r
\name{rename_attrs}
\alias{rename_attrs}
\title{Rename relational data attributes}
\usage{
rename_attrs(x, names, ...)
}
\arguments{
\item{x}{an object with an \code{attrs_order} attribute. This includes
relational schema objects, such as a \code{\link{relation_schema}} or
\code{\link{database_schema}} object, relational data objects, such as a
\code{\link{relation}} or \code{\link{database}} object, and
\code{\link{functional_dependency}} objects.}

\item{names}{a character vector of the same length as \code{attrs_order(x)},
with no duplicated elements, to be used as the new attribute names.}

\item{...}{further arguments passed on to methods.}
}
\value{
A relational object of the same type as \code{x}, with attributes
renamed consistently across the whole object.
}
\description{
Generic function, for renaming attributes present in a database-like
structure.
}
\details{
This function has a different intended use to re-assigning
\code{\link{attrs_order}}: that is intended only for rearranging the order of
the attributes, without renaming them. This is intended for renaming the
attributes without re-ordering them.
}
