% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.scale.R
\name{legend.scale}
\alias{legend.scale}
\title{Plot an legend scale.}
\usage{
legend.scale(zlim, col = heat.colors(12), horizontal = TRUE, breaks,
  axis.args)
}
\arguments{
\item{zlim}{The quantitative limits of the variable of interest.}

\item{col}{The color gradient used in the scale.  The default is the 12 colors generated by \code{heat.colors(12)}.}

\item{horizontal}{A logical value indicating whether the legend should have a horizontal (\code{TRUE}) or vertical (\code{FALSE}) orientation.  The default is \code{TRUE}.}

\item{breaks}{The sequence of values defining the partition of \code{zlim}.  The length should be one more than then number of colors.  If not specified, then equidistant breaks are automatically used.}

\item{axis.args}{A list specifying argument values for the \code{\link[graphics]{axis}} function.  Can be used to modify the scale of the legend.  See Examples.}
}
\description{
\code{legend.scale} plots a color gradient with an associated quantitive scale.  This is used to add the legend scale in the \code{\link{autoimage}} function.
}
\examples{
# default horizontal scale
legend.scale(c(0, 1))

# default vertical scale
legend.scale(c(0, 1), horizontal = FALSE)

# different color scheme with 24 colors
legend.scale(c(0, 1), col = cm.colors(24))

# irregular color breaks
legend.scale(c(0, 1), col = heat.colors(4), breaks = c(0, 0.5, 0.75, 0.875, 1))

# irregular color breaks with modified ticks and vertical orientation of labels
legend.scale(c(0, 1), col = heat.colors(4),
             breaks = c(0, 0.5, 0.75, 0.875, 1),
             axis.args = list(at = c(0, 0.5, 0.75, 0.875, 1), las = 2))

# change size of axis labels
legend.scale(c(0, 1), axis.args = list(cex.axis = 2))

# change color of axis labels and ticks
legend.scale(c(0, 1), axis.args = list(col.axis = "blue", col.ticks = "blue"))

# log base 2 values with colors labelled on original scale
legend.scale(c(0, 12), axis.args = list(at = 0:12, labels = 2^(0:12), las = 2))
}
\references{
The code for this function is derived from the internals of the \code{\link[fields]{image.plot}} function written by Doug Nychka and from the \code{image.scale} function written by Marc Taylor and discussed at \url{http://menugget.blogspot.com/2013/12/new-version-of-imagescale-function.html}.
}
\seealso{
\code{\link[graphics]{image}}, \code{\link[fields]{image.plot}}, \code{\link[graphics]{axis}}
}

