% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pimage.R
\name{pimage}
\alias{pimage}
\title{Display image for projected coordinates}
\usage{
pimage(x, y, z, legend = "horizontal", proj = "none", parameters,
  orientation, lratio = 0.2, map = "none", ...)
}
\arguments{
\item{x, y}{Locations of grid points at which the values in \code{z}
are measured.  The values must be finite and non-missing.  These 
arguments can be either vectors or matrices depending on the type
of data to be displayed.  See Details.}

\item{z}{A numeric or logical vector or matrix containing the 
values to be plotted (NAs are allowed).}

\item{legend}{A character string indicating where the color scale 
should be placed.  The default is \code{"horizontal"}.  The other
valid options are \code{"none"} and \code{"vertical"}.}

\item{proj}{A character string indicating what projection should be
used for the included \code{x} and \code{y} coordinates.  The 
default is \code{"none"}.  The other valid choices correspond to 
the \code{"projection"} argument in the 
\code{\link[mapproj]{mapproject}} function, which is used for the
projection.}

\item{parameters}{A numeric vector specifying the values of the 
\code{parameters} argument in the 
\code{\link[mapproj]{mapproject}}.  This may be necessary when
\code{proj != "none"}.}

\item{orientation}{A vector \code{c(latitude,longitude,rotation)} 
which describes where the "North Pole" should be when computing 
the projection.  See \code{\link[mapproj]{mapproject}} for more
details.}

\item{lratio}{A numeric value indicating the ratio of the smaller 
dimension of the legend scale to the width of the image.  Default
is \code{lratio = 0.2}.}

\item{map}{The name of the map to draw on the image. Default is 
\code{"none"}.  Other options include \code{"world"}, 
\code{"usa"}, \code{"state"}, \code{"county"}, \code{"france"}, 
\code{"nz"} (New Zealand), \code{"italy"}, \code{"lakes"}, and
\code{"world2"}, all from the \code{maps} package.}

\item{...}{Additional arguments passed to the 
\code{\link[graphics]{image}} or \code{\link[fields]{poly.image}}
functions.  e.g., \code{xlab}, \code{ylab}, \code{xlim}, 
\code{ylim}, \code{zlim}, etc.  Additionally, arguments that can 
be used to further customize the plot (like adding lines or 
points), as described in Details and Examples.}
}
\description{
\code{pimage} plots an image for (potentially) projected locations.
A color scale is automatically provided with the image. The 
function is essentially an extension of the 
\code{\link[graphics]{image}} function and the \code{x} and 
\code{y} locations can be irregularly-spaced locations, sequences 
of increasing values for locations on a regular grid, or matrices 
(with dimensions matching those of \code{z}) for locations on an 
irregular grid.  Functionality for automatic projection is 
provided.
}
\details{
If \code{x}, \code{y}, and \code{z} are numeric vectors of the same
length, then the \code{\link[akima]{interp}} function is used to 
interpolate the locations onto a regular grid before constructing 
the image.  This interpolation can be customized by passing 
\code{interp.args} through \code{...}.  \code{interp.args} should 
be a named list with component matching the non \code{x}, \code{y},
and \code{z} arguments of the \code{\link[akima]{interp}} function.

If \code{x} are \code{y} are vectors of increasing values and 
\code{nrow(z) == length(x)} and \code{ncol(z) == length(y)}, then 
an image on a regular grid is constructed.

If \code{x}, \code{y} and \code{z} are matrices with the same 
dimensions, then an image for irregularly gridded data is 
constructed.

When \code{proj != "none"}, the \code{\link[mapproj]{mapproject}} 
function is used to project the \code{x} and \code{y} coordinates. 
In that case, \code{proj} must correspond to one of the choices for
the \code{projection} argument in the 
\code{\link[mapproj]{mapproject}} function.  Necessary arguments 
for \code{\link[mapproj]{mapproject}} should be provided via the 
\code{parameters} and \code{orientation} arguments. See Examples 
and the \code{\link[mapproj]{mapproject}} function.

Valid options for \code{legend} are \code{"none"}, 
\code{"horizontal"}, and \code{"vertical"}.  If \code{legend = 
"none"}, then no color scale is provided.  If \code{legend = 
"horizontal"}, then a color scale is included under the image.  If 
\code{legend = "vertical"}, then a color scale is added to the 
right of the image.

Lines can be added to each image by passing the \code{lines} 
argument through \code{...}.  In that case, \code{lines} should be
a list with components \code{x} and \code{y} specifying the
locations to draw the lines.  The appearance of the plotted lines
can be customized by passing a named list called \code{lines.args}
through \code{...}. The components of \code{lines.args} should match
the arguments of \code{\link[graphics]{lines}}.  See Examples.

Points can be added to each image by passing the \code{points} 
argument through \code{...}.  In that case, \code{points} should be
a list with components \code{x} and \code{y} specifying the
locations to draw the points.  The appearance of the plotted points
can be customized by passing a named list called \code{points.args}
through \code{...}. The components of \code{points.args} should match
the components of \code{\link[graphics]{points}}.  See Examples.

Text can be added to each image by passing the \code{text} 
argument through \code{...}.  In that case, \code{text} should be
a list with components \code{x} and \code{y} specifying the
locations to draw the text, and \code{labels}, a component
specifying the actual text to write.  The appearance of the plotted text
can be customized by passing a named list called \code{text.args}
through \code{...}. The components of \code{text.args} should match
the components of \code{\link[graphics]{text}}.  See Examples.

The legend scale can be modified by passing \code{legend.axis.args}
through \code{...}.  The argument should be a named list 
corresponding to the arguments of the \code{\link[graphics]{axis}} 
function.  See Examples.

The image axes can be modified by passing \code{axis.args} through
\code{...}.  The argument should be a named list corresponding to
the arguments of the \code{\link[graphics]{axis}} function.  The
exception to this is that arguments \code{xat} and \code{yat} can
be specified (instead of \code{at}) to specify the location of the
x and y ticks.  If \code{xat} or \code{yat} are specified, then
this overrides the \code{xaxt} and \code{yaxt} arguments,
respectively.  See the \code{\link[autoimage]{paxes}} function to
see how \code{axis.args} can be used.

The legend margin can be customized by passing \code{legend.mar} to
\code{pimage} through \code{...}.  This should be a numeric vector
indicating the margins of the legend, identical to how 
\code{par("mar")} is specified.

The various options of the labeling, axes, and legend are largely
independent.  e.g., passing \code{col.axis} through \code{...} 
will not affect the axis unless it is passed as part of the 
named list \code{axis.args}.  However, one can set the various
\code{par} options prior to plotting to simultaneously
affect the appearance of multiple aspects of the plot.  See 
Examples.  After plotting, \code{reset.par()} can be used to reset 
the graphics device options to their default values.
}
\examples{
# image plot for data on an irregular grid
pimage(lon, lat, tasmax[,,1], legend = "h", map = "world")
# same plot but with projection and vertical legend
pimage(lon, lat, tasmax[,,1], legend = "v", map = "world", 
       proj = "bonne", parameters = 45)
# different projection
pimage(lon, lat, tasmax[,,1], proj = "albers",
       parameters = c(33, 45), map = "world")

reset.par() # reset graphics device
# image plot for non-gridded data
data(co, package = "gear")
pimage(co$longitude, co$latitude, co$Al)

# show observed locations on image,
# along with Colorado border, locations of Denver and Colorado 
# Springs
data(copoly)
copoints <- list(x = co$lon, y = co$lat)
pimage(co$longitude, co$latitude, co$Al, 
       lines = copoly, 
       lines.args = list(lwd = 2, col = "grey"),
       points = copoints, 
       points.args = list(pch = 21, bg = "white"),
       text = list(x = c(-104.98, -104.80), y = c(39.74, 38.85), 
                   labels = c("Denver", "Colorado Springs")), 
       text.args = list(col = "purple"),
       xlim = c(-109.1, -102),
       ylim = c(36.8, 41.1))

# image plot for data on irregular grid
# notice the poor axis labeling
data(narccap)
pimage(lon, lat, tasmax[,,1], proj = "bonne",
       parameters = 45, map = "world")
# same plot but customize axis labeling 
# need to extend horizontally-running axis lines
# farther to the west and east
# also need the vertically-running lines
# to run further north/sount
# will need manual adjusting depending on size
# of current device 
pimage(lon, lat, tasmax[,,1], proj = "bonne",
       parameters = 45, map = "world", 
       xaxp = c(-200, 0, 10), yaxp = c(-10, 80, 9))

# the same effect can be acheived by specifying axis.args
# we also modify the color and size of the axis labels
pimage(lon, lat, tasmax[,,1], proj = "bonne",
       parameters = 45, map = "world", 
       axis.args = list(xat = seq(-200, 0, by = 20),
                        yat = seq(0, 70, by = 10),
                        col.axis = "blue", 
                        cex.axis = 0.5))

# modify colors of legend, map, line type for grid lines
# and customize axis
pimage(lon, lat, tasmax[,,1], 
       legend = "v", proj = "bonne", parameters = 45,
       map = "state",
       paxes.args = list(lty = 3),
       legend.axis.args = list(col = "blue", col.axis = "blue"),
       col = fields::tim.colors(64),
       xlab = "longitude",
       ylab = "latitude",
       main = "temperature (K)")
reset.par() # reset graphics device

# change many aspects of plot appearance using par
par(cex.axis = 0.5, cex.lab = 0.5, mgp = c(1.5, 0.5, 0),
    mar = c(2.1, 2.1, 4.1, 0.2), col.axis = "orange",
    col.main = "blue", family = "mono")
pimage(lon, lat, tasmax[,,1])
title("very customized plot")
reset.par()

}
\seealso{
\code{\link[graphics]{image}}, 
  \code{\link[fields]{image.plot}}, \code{\link[graphics]{axis}}
}
