% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-AutomatedTest.R
\name{AutomatedTest}
\alias{AutomatedTest}
\title{AutomatedTest class}
\description{
The AutomatedTest class represents a result of a statistical test. It contains attributes such as the p-value, degrees of freedom, and more.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AutomatedTest-new}{\code{AutomatedTest$new()}}
\item \href{#method-AutomatedTest-getData}{\code{AutomatedTest$getData()}}
\item \href{#method-AutomatedTest-isPaired}{\code{AutomatedTest$isPaired()}}
\item \href{#method-AutomatedTest-getIdentifiers}{\code{AutomatedTest$getIdentifiers()}}
\item \href{#method-AutomatedTest-getCompareTo}{\code{AutomatedTest$getCompareTo()}}
\item \href{#method-AutomatedTest-setCompareTo}{\code{AutomatedTest$setCompareTo()}}
\item \href{#method-AutomatedTest-getDatatypes}{\code{AutomatedTest$getDatatypes()}}
\item \href{#method-AutomatedTest-getParametricList}{\code{AutomatedTest$getParametricList()}}
\item \href{#method-AutomatedTest-isParametric}{\code{AutomatedTest$isParametric()}}
\item \href{#method-AutomatedTest-getTest}{\code{AutomatedTest$getTest()}}
\item \href{#method-AutomatedTest-getResult}{\code{AutomatedTest$getResult()}}
\item \href{#method-AutomatedTest-getStrength}{\code{AutomatedTest$getStrength()}}
\item \href{#method-AutomatedTest-isSignificant}{\code{AutomatedTest$isSignificant()}}
\item \href{#method-AutomatedTest-print}{\code{AutomatedTest$print()}}
\item \href{#method-AutomatedTest-clone}{\code{AutomatedTest$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-new"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-new}{}}}
\subsection{Method \code{new()}}{
Initialize an instance of the AutomatedTest class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$new(data, identifiers, compare_to = NULL, paired = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A dataframe containing the data for the test.}

\item{\code{identifiers}}{A vector with the identifiers.}

\item{\code{compare_to}}{Numeric value to compare to for comparison in one-sample tests. Default is NULL.}

\item{\code{paired}}{Logical; if TRUE, the test will be performed as paired if applicable. Default is FALSE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-getData"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-getData}{}}}
\subsection{Method \code{getData()}}{
Get the data used in the test
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$getData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A dataframe with all features
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-isPaired"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-isPaired}{}}}
\subsection{Method \code{isPaired()}}{
Shows if the data is paired, if there are multiple rows with the same identifier, the data has more
samples (TIDY DATA). Making the data paired.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$isPaired()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Whether the data is paired (TRUE/FALSE).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-getIdentifiers"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-getIdentifiers}{}}}
\subsection{Method \code{getIdentifiers()}}{
A list of the identifiers used for the data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$getIdentifiers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the identifiers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-getCompareTo"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-getCompareTo}{}}}
\subsection{Method \code{getCompareTo()}}{
Get the comparison value for one-sample tests
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$getCompareTo()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric value for comparison
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-setCompareTo"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-setCompareTo}{}}}
\subsection{Method \code{setCompareTo()}}{
Updates the compare_to variable. Is public because the
compare value can get changed depending on the type of test.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$setCompareTo(compare_to)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{compare_to}}{Numeric value to compare to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated object with comparison value set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-getDatatypes"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-getDatatypes}{}}}
\subsection{Method \code{getDatatypes()}}{
Get the data types of the features in the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$getDatatypes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of data types (e.g., Quantitative or Qualitative)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-getParametricList"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-getParametricList}{}}}
\subsection{Method \code{getParametricList()}}{
Get the parametric test results of the features
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$getParametricList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of parametric test results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-isParametric"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-isParametric}{}}}
\subsection{Method \code{isParametric()}}{
Check if the data meets parametric assumptions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$isParametric()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if parametric assumptions are met, otherwise FALSE
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-getTest"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-getTest}{}}}
\subsection{Method \code{getTest()}}{
Get the statistical test that was chosen
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$getTest()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The name of the statistical test
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-getResult"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-getResult}{}}}
\subsection{Method \code{getResult()}}{
Get the result of selected statistical test
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$getResult()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The result of the statistical test
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-getStrength"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-getStrength}{}}}
\subsection{Method \code{getStrength()}}{
Get the strength(s) of selected statistical test.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$getStrength()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named numeric value indicating the strength of the result.
The type and meaning depend on the test used:
\describe{
  \item{coefficient}{Effect size and direction of predictors in regression}
  \item{r}{Correlation strength and direction}
  \item{mean difference}{Difference in group means}
  \item{statistic}{Test statistic measuring group difference or association}
  \item{F statistic}{Ratio of variances across groups}
  \item{proportion}{Estimated success rate in the sample}
  \item{non-existent}{No interpretable strength measure available}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-isSignificant"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-isSignificant}{}}}
\subsection{Method \code{isSignificant()}}{
Whether the test results are significant or not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$isSignificant()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE / FALSE depending on the significance of the test.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-print"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of the test object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
