% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_marks}
\alias{am_marks}
\title{Get all marks in a text object}
\usage{
am_marks(obj)
}
\arguments{
\item{obj}{An Automerge object ID (must be a text object)}
}
\value{
A list of marks, where each mark is a list with fields:
\describe{
\item{name}{Character string identifying the mark}
\item{value}{The mark's value (various types supported)}
\item{start}{Integer start position (0-based inter-character position, inclusive)}
\item{end}{Integer end position (0-based inter-character position, exclusive)}
}
Returns an empty list if no marks are present. See \code{\link[=am_mark]{am_mark()}} for
indexing details.
}
\description{
Retrieves all marks (formatting/metadata annotations) present in a text
object at a specific document state.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

am_mark(text_obj, 0, 5, "bold", TRUE)
am_mark(text_obj, 6, 11, "italic", TRUE)

marks <- am_marks(text_obj)
marks
# List of 2 marks with name, value, start, end
}
