% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_anova.R
\name{auto_anova}
\alias{auto_anova}
\title{auto anova}
\usage{
auto_anova(
  data,
  ...,
  baseline = c("mean", "median", "first_level", "user_supplied"),
  user_supplied_baseline = NULL,
  sparse = FALSE,
  pval_thresh = 0.1
)
}
\arguments{
\item{data}{a data frame}

\item{...}{tidyselect specification or cols}

\item{baseline}{choose from "mean", "median", "first_level", "user_supplied". what is the baseline to compare each category to? can use the mean and median of the target variable as a global baseline}

\item{user_supplied_baseline}{if intercept is "user_supplied", can enter a numeric value}

\item{sparse}{default FALSE; if true returns a truncated output with only significant results}

\item{pval_thresh}{control significance level for sparse output filtering}
}
\value{
data frame
}
\description{
A wrapper around lm and anova to run a regression of a continuous variable against categorical variables.
Used for determining the whether the mean of a continuous variable is statistically significant amongst different levels
of a categorical variable.
}
\details{
Columns can be inputted as unquoted names or tidyselect. Continuous and categorical variables are automatically determined.
If no character or factor column is present, the column with the lowest amount of unique values will be considered
the categorical variable.

Description of columns in the output

\itemize{
\item{\emph{target}}{ continuous variables}
\item{\emph{predictor}}{ categorical variables}
\item{\emph{level}}{ levels in the categorical variables}
\item{\emph{estimate}}{ difference between level target mean and baseline}
\item{\emph{target_mean}}{ target mean per level}
\item{\emph{n}}{ rows in predictor level}
\item{\emph{std.error}}{ standard error of target in predictor level}
\item{\emph{level_p.value}}{ p.value for t.test of whether target mean differs significantly between level and baseline}
\item{\emph{level_significance}}{ level p.value represented by stars}
\item{\emph{predictor_p.value}}{ p.value for significance of entire predictor given by F test}
\item{\emph{predictor_significance}}{ predictor p.value represented by stars}
\item{\emph{conclusion}}{ text interpretation of tests}
}
}
\examples{

iris \%>\%
auto_anova(tidyselect::everything()) -> iris_anova1


iris_anova1 \%>\%
print(width = Inf)
}
