% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_associate_route_table}
\alias{ec2_associate_route_table}
\title{Associate Route Table}
\usage{
ec2_associate_route_table(
  RouteTableId,
  DryRun = NULL,
  SubnetId = NULL,
  GatewayId = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{RouteTableId}{String. The ID of the route table.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{SubnetId}{String. The ID of the subnet.[optional]}

\item{GatewayId}{String. The ID of the internet gateway or virtual private gateway.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Associate Route Table
}
\section{RouteTableId}{

The ID of the route
table.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{SubnetId}{

The ID of the
subnet.
}

\section{GatewayId}{

The ID of the internet gateway or virtual
private gateway.
}

