% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_network_insights_path}
\alias{ec2_create_network_insights_path}
\title{Create Network Insights Path}
\usage{
ec2_create_network_insights_path(
  Source,
  Destination,
  Protocol,
  ClientToken,
  SourceIp = NULL,
  DestinationIp = NULL,
  DestinationPort = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Source}{String. The AWS resource that is the source of the path.}

\item{Destination}{String. The AWS resource that is the destination of the path.}

\item{Protocol}{String. The protocol.}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.}

\item{SourceIp}{String. The IP address of the AWS resource that is the source of the path.[optional]}

\item{DestinationIp}{String. The IP address of the AWS resource that is the destination of the path.[optional]}

\item{DestinationPort}{Integer. The destination port.[optional]}

\item{TagSpecification}{List. The tags to add to the path.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Network Insights Path
}
\section{Source}{

The AWS resource that is the
source of the path.
}

\section{Destination}{

The AWS resource that is the
destination of the path.
}

\section{Protocol}{

The
protocol.
}

\section{ClientToken}{

Unique, case-sensitive identifier that you
provide to ensure the idempotency of the request. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.
}

\section{SourceIp}{

The
IP address of the AWS resource that is the source of the
path.
}

\section{DestinationIp}{

The IP address of the AWS resource that is the
destination of the path.
}

\section{DestinationPort}{

The destination
port.
}

\section{TagSpecification}{

The tags to add to the
path.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

