% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_route}
\alias{ec2_delete_route}
\title{Delete Route}
\usage{
ec2_delete_route(
  RouteTableId,
  DestinationCidrBlock = NULL,
  DestinationIpv6CidrBlock = NULL,
  DestinationPrefixListId = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{RouteTableId}{String. The ID of the route table.}

\item{DestinationCidrBlock}{String. The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.[optional]}

\item{DestinationIpv6CidrBlock}{String. The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.[optional]}

\item{DestinationPrefixListId}{String. The ID of the prefix list for the route.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the specified route from the
specified route table.
}
\section{RouteTableId}{

The ID of the route
table.
}

\section{DestinationCidrBlock}{

The IPv4 CIDR range for the route. The value
you specify must match the CIDR for the route
exactly.
}

\section{DestinationIpv6CidrBlock}{

The IPv6 CIDR range for the route. The
value you specify must match the CIDR for the route
exactly.
}

\section{DestinationPrefixListId}{

The ID of the prefix list for the
route.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

