% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_scheduled_instances}
\alias{ec2_describe_scheduled_instances}
\title{Describe Scheduled Instances}
\usage{
ec2_describe_scheduled_instances(
  DryRun = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  ScheduledInstanceId = NULL,
  SlotStartTimeRange = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{ScheduledInstanceId}{List. The Scheduled Instance IDs.[optional]}

\item{SlotStartTimeRange}{Object. The time period for the first schedule to start.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the specified Scheduled Instances or all
your Scheduled Instances.
}
\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Filter}{


The filters.
\itemize{
\item \code{availability-zone} - The Availability Zone (for example,
\verb{us-west-2a}).
\item \code{instance-type} - The instance type (for example, \code{c4.large}).
\item \code{network-platform} - The network platform (\code{EC2-Classic} or
\code{EC2-VPC}).
\item \code{platform} - The platform (\code{Linux/UNIX} or \code{Windows}).
}
}

\section{MaxResults}{

The maximum number of results to return in a single
call. This value can be between 5 and 300. The default value is 100. To
retrieve the remaining results, make another call with the returned
\code{NextToken} value.
}

\section{ScheduledInstanceId}{

The Scheduled Instance
IDs.
}

\section{SlotStartTimeRange}{

The time period for the first schedule to
start.
}

