% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_traffic_mirror_sessions}
\alias{ec2_describe_traffic_mirror_sessions}
\title{Describe Traffic Mirror Sessions}
\usage{
ec2_describe_traffic_mirror_sessions(
  TrafficMirrorSessionId = NULL,
  DryRun = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TrafficMirrorSessionId}{List. The ID of the Traffic Mirror session.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more Traffic Mirror
sessions. By default, all Traffic Mirror sessions are described.
Alternatively, you can filter the
results.
}
\section{TrafficMirrorSessionId}{

The ID of the Traffic Mirror
session.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Filter}{


One or more filters. The possible values are:
\itemize{
\item \code{description}: The Traffic Mirror session description.
\item \code{network-interface-id}: The ID of the Traffic Mirror session network
interface.
\item \code{owner-id}: The ID of the account that owns the Traffic Mirror
session.
\item \code{packet-length}: The assigned number of packets to mirror.
\item \code{session-number}: The assigned session number.
\item \code{traffic-mirror-filter-id}: The ID of the Traffic Mirror filter.
\item \code{traffic-mirror-session-id}: The ID of the Traffic Mirror session.
\item \code{traffic-mirror-target-id}: The ID of the Traffic Mirror target.
\item \code{virtual-network-id}: The virtual network ID of the Traffic Mirror
session.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

