% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_volume}
\alias{ec2_modify_volume}
\title{Modify Volume}
\usage{
ec2_modify_volume(
  VolumeId,
  DryRun = NULL,
  Size = NULL,
  VolumeType = NULL,
  Iops = NULL,
  Throughput = NULL,
  MultiAttachEnabled = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VolumeId}{String. The ID of the volume.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Size}{Integer.   The target size of the volume, in GiB.[optional]}

\item{VolumeType}{String.   The target EBS volume type of the volume.[optional]}

\item{Iops}{Integer.   The target IOPS rate of the volume.[optional]}

\item{Throughput}{Integer.   The target throughput of the volume, in MiB/s.[optional]}

\item{MultiAttachEnabled}{Logical. Specifies whether to enable Amazon EBS Multi-Attach.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Volume
}
\section{VolumeId}{

The ID of the
volume.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Size}{


The target size of the volume, in GiB. The target volume size must be
greater than or equal to the existing size of the volume.

The following are the supported volumes sizes for each volume type:
\itemize{
\item \code{gp2} and \code{gp3}: 1-16,384
\item \code{io1} and \code{io2}: 4-16,384
\item \code{st1} and \code{sc1}: 125-16,384
\item \code{standard}: 1-1,024
}

Default: If no size is specified, the existing size is retained.
}

\section{VolumeType}{


The target EBS volume type of the volume. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html}{Amazon EBS volume types}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

Default: If no type is specified, the existing type is retained.
}

\section{Iops}{


The target IOPS rate of the volume. This parameter is valid only for
\code{gp3}, \code{io1}, and \code{io2} volumes.

The following are the supported values for each volume type:
\itemize{
\item \code{gp3}: 3,000-16,000 IOPS
\item \code{io1}: 100-64,000 IOPS
\item \code{io2}: 100-64,000 IOPS
}

Default: If no IOPS value is specified, the existing value is retained.
}

\section{Throughput}{


The target throughput of the volume, in MiB/s. This parameter is valid
only for \code{gp3} volumes. The maximum value is 1,000.

Default: If no throughput value is specified, the existing value is
retained.

Valid Range: Minimum value of 125. Maximum value of 1000.
}

\section{MultiAttachEnabled}{

Specifies whether to enable Amazon EBS
Multi-Attach. If you enable Multi-Attach, you can attach the volume to
up to 16 \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances}{Nitro-based instances}
in the same Availability Zone. This parameter is supported with \code{io1}
and \code{io2} volumes only. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html}{Amazon EBS Multi-Attach}
in the \emph{Amazon Elastic Compute Cloud User
Guide}.
}

