% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpc_endpoint_connection_notification}
\alias{ec2_modify_vpc_endpoint_connection_notification}
\title{Modify Vpc Endpoint Connection Notification}
\usage{
ec2_modify_vpc_endpoint_connection_notification(
  ConnectionNotificationId,
  DryRun = NULL,
  ConnectionNotificationArn = NULL,
  ConnectionEvents = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ConnectionNotificationId}{String. The ID of the notification.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ConnectionNotificationArn}{String. The ARN for the SNS topic for the notification.[optional]}

\item{ConnectionEvents}{List. One or more events for the endpoint. Valid values are \code{Accept}, \code{Connect}, \code{Delete}, and \code{Reject}.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modifies a connection notification for VPC
endpoint or VPC endpoint service. You can change the SNS topic for the
notification, or the events for which to be notified.
}
\section{ConnectionNotificationId}{

The
ID of the notification.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ConnectionNotificationArn}{

The ARN for the SNS topic
for the notification.
}

\section{ConnectionEvents}{

One or more events for the
endpoint. Valid values are \code{Accept}, \code{Connect}, \code{Delete}, and
\code{Reject}.
}

