% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy.R
\name{add_policy}
\alias{add_policy}
\alias{update_policy}
\alias{get_policy}
\alias{delete_policy}
\alias{list_policies}
\title{Manage IAM Polices}
\usage{
add_policy(user, group, role, policy, doc, ...)

update_policy(role, doc, ...)

get_policy(policy, user, group, role, ...)

delete_policy(user, group, role, policy, ...)

list_policies(user, group, role, n, marker, ...)
}
\arguments{
\item{user}{A character string specifying a user name or an object of class \dQuote{iam_user}.}

\item{group}{A character string containing a group name or an object of class \dQuote{iam_group}.}

\item{role}{A character string containing a role name or an object of class \dQuote{iam_role}.}

\item{policy}{A character string specifying the policy name.}

\item{doc}{The contents of the policy document as a character string.}

\item{\dots}{Additional arguments passed to \code{\link{iamHTTP}}.}

\item{n}{An integer specifying the number of responses to return.}

\item{marker}{A character string specifying a marker (from a previous response) to use in paginating results}
}
\value{
\code{add_policy} and \code{get_policy} return objects of class \dQuote{iam_policy}. \code{update_policy} and \code{delete_policy} return a logical \code{TRUE} (if successful) or an error. \code{list_policies} returns a list of IAM role objects.
}
\description{
Retrieve, create, update, and delete IAM Role, User, and Group Polices
}
