% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queue.R
\name{purge_queue}
\alias{purge_queue}
\title{Purge a queue}
\usage{
purge_queue(queue, query = NULL, ...)
}
\arguments{
\item{queue}{A character string containing a queue URL, or the name of the queue.}

\item{query}{A list specifying additional query arguments to be passed to the \code{query} argument of \code{\link{sqsHTTP}}.}

\item{...}{Additional arguments passed to \code{\link{sqsHTTP}}.}
}
\value{
If successful, a logical \code{TRUE} value. Otherwise, a data structure of class \dQuote{aws_error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
Purge an SQS queue of its message
}
\details{
Purge an SQS queue of its messages, without deleting it. Use \code{\link{delete_queue}} to delete the queue entirely.
}
\references{
\href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_PurgeeQueue.html}{PurgeQueue}
}
\seealso{
\code{link{create_queue}} \code{\link{delete_queue}}
}
\author{
Thomas J. Leeper
}
