% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{get_run_metrics}
\alias{get_run_metrics}
\title{Get the metrics logged to a run}
\usage{
get_run_metrics(run)
}
\arguments{
\item{run}{The \code{Run} object.}
}
\value{
A named list of the metrics associated with the run,
e.g. \code{list("metric_name" = metric)}.
}
\description{
Retrieve the metrics logged to a run that were logged with
the \code{log_*()} methods.
}
\examples{
\dontrun{
ws <- load_workspace_from_config()
exp <- experiment(ws, name = 'myexperiment')
run <- get_run(exp, run_id = "myrunid")
metrics <- get_run_metrics(run)
}
}
