% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{log_row_to_run}
\alias{log_row_to_run}
\title{Log a row metric to a run}
\usage{
log_row_to_run(name, description = "", run = NULL, ...)
}
\arguments{
\item{name}{A string of the name of metric.}

\item{description}{(Optional) A string of the metric description.}

\item{run}{The \code{Run} object. If not specified, will default
to the current run from the service context.}

\item{...}{Each named parameter generates a column with the value
specified.}
}
\value{
None
}
\description{
Using \code{log_row_to_run()} creates a metric with multiple columns
as described in \code{...}. Each named parameter generates a column
with the value specified. \code{log_row_to_run()} can be called once
to log an arbitrary tuple, or multiple times in a loop to generate
a complete table.
}
\examples{
# Log an arbitrary tuple
\dontrun{
log_row_to_run("Y over X", x = 1, y = 0.4)
}

# Log the complete table
\dontrun{
citrus <- c("orange", "lemon", "lime")
sizes <- c(10, 7, 3)
for (i in seq_along(citrus)) {
    log_row_to_run("citrus", fruit = citrus[i], size = sizes[i])
}
}
}
