% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{mount_file_dataset}
\alias{mount_file_dataset}
\title{Create a context manager for mounting file streams defined by the dataset as local files.}
\usage{
mount_file_dataset(dataset, mount_point)
}
\arguments{
\item{dataset}{The Dataset object.}

\item{mount_point}{The local directory to mount the files to. If NULL, the
data will be mounted into a temporary directory.}
}
\value{
Returns a context manager for managing the lifecycle of the mount of
type \code{azureml.dataprep.fuse.daemon.MountContext}.
}
\description{
Create a context manager for mounting file streams defined by the dataset as local files.
A context manager will be returned to manage the lifecycle of the mount.
To mount, you will need to enter the context manager and to unmount, exit from
the context manager. Mount is only supported on Unix or Unix-like operating systems
and libfuse must be present. If you are running inside a docker container, the docker
container must be started with the \code{--privileged} flag or started with
\code{--cap-add SYS_ADMIN --device /dev/fuse}.
}
