% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbt_delete_temp_files.R
\name{bbt_delete_temp_files}
\alias{bbt_delete_temp_files}
\title{Delete all the temporary files created by \link{bbt_run_from_model}}
\usage{
bbt_delete_temp_files(inference_model, beast2_options)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model,
as returned by \link[beautier]{create_inference_model}}

\item{beast2_options}{'BEAST2'  options,
as can be created by \link[beastier]{create_beast2_options}}
}
\description{
Delete all the temporary files created by \link{bbt_run_from_model}
}
\examples{
if (is_beast2_installed()) {
  # Do a minimal run
  inference_model <- create_test_inference_model()
  beast2_options <- create_beast2_options()
  bbt_run_from_model(
    fasta_filename = get_fasta_filename(),
    inference_model = inference_model,
    beast2_options = beast2_options
  )

  # Cleanup
  bbt_delete_temp_files(
    inference_model = inference_model,
    beast2_options = beast2_options
  )
}
}
