% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-BabsimCaselog.R
\name{RiskScore}
\alias{RiskScore}
\title{Calculate risk scores}
\usage{
RiskScore(cases, par)
}
\arguments{
\item{cases}{[\code{object}] \cr table of cases, one per row.}

\item{par}{[\code{list()}] \cr parameters of risk model.}
}
\value{
Vector of risk scores.
}
\description{
Calculate a risk score based on age and sex of patient for a set of cases.
}
\details{
The risk score is calculated according to the following formula:
\deqn{\code{RiskScore} = \code{RiskFactorA}  exp(\code{RiskFactorB} \code{age}) (1 + I_{male} (\code{RiskMale} - 1)}
Here the \code{RiskFactorA}, \code{RiskFactorB} and \code{RiskMale} are taken from the parameter list \code{par} and the \code{age} and \code{sex} are taken from the \code{cases} .
}
