% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runoptUK.R
\name{runoptUK}
\alias{runoptUK}
\title{runoptUK Optimierung der babsim.hospital Parameter}
\usage{
runoptUK(
  expName = "ukl001",
  simData = simData,
  fieldData = fieldData,
  TrainFieldStartDate = Sys.Date() - 6 * 7,
  TrainSimStartDate = Sys.Date() - 10 * 7,
  TestFieldStartDate = Sys.Date() - 4 * 7,
  TestSimStartDate = Sys.Date() - 8 * 7,
  Overlap = 0,
  verbosity = 0,
  seed = 123,
  repeats = 1,
  funEvals = 35,
  size = 30,
  simrepeats = 2,
  subset = 32,
  parallel = FALSE,
  percCores = 0.8,
  icu = FALSE,
  icuWeights = c(1, 1, 1),
  testRepeats = 3,
  resourceNames = c("bed", "intensiveBed", "intensiveBedVentilation"),
  resourceEval = c("bed", "intensiveBed", "intensiveBedVentilation"),
  factorUK = 1,
  factorIcuUK = 1
)
}
\arguments{
\item{expName}{Experiment Name}

\item{simData}{RKI Daten}

\item{fieldData}{ICU Daten}

\item{TrainFieldStartDate}{Start (Tag), e.g., \code{"2020-06-01"}}

\item{TrainSimStartDate}{Start (Tag), e.g., \code{"2020-05-01"}}

\item{TestFieldStartDate}{Start (Day), e.g., \code{"2020-06-01"} for test field data}

\item{TestSimStartDate}{Start (Day), e.g., \code{"2020-05-01"} for test simulation data,
TestSimStartDate is usually before TestFieldStartDate}

\item{Overlap}{integer. Days, train data will be extended (overlap with test data). Default: 7}

\item{verbosity}{verbosity (int). Default: \code{0}}

\item{seed}{Seed}

\item{repeats}{Wiederholungen fuer SPOT (Optimierungslaeufe mit unterschiedlichem Seed)}

\item{funEvals}{Auswertungen fuer SPOT (Simulationen, 
die fuer einen SPOT Lauf zur Verfuegung stehen)}

\item{size}{Groesse des initialen Desings}

\item{simrepeats}{Sim Wdhlg}

\item{subset}{Subset (SPOT)}

\item{parallel}{logical}

\item{percCores}{percentage}

\item{icu}{ICU Daten}

\item{icuWeights}{Gewichtung der ICU Betten}

\item{testRepeats}{number of final evaluations on the test data}

\item{resourceNames}{Name der Ressourcen}

\item{resourceEval}{Name der zu evaluierenden Ressourcen}

\item{factorUK}{factor to adapt the percentage of patients ventilated. For example,
if set to `0.5`, only 50 percent of the default number of patients will be ventilated.
Default: 1}

\item{factorIcuUK}{factor to adapt the duration on ICU. For example,
if set to `0.5`, patients stay on half the time at ICU
Default: 1}
}
\description{
SPOT Aufruf zur Optimierung der babsim Parameter
}
\examples{

\dontrun{
res <- runoptUK()
}

}
