% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2HideFile.R
\name{b2HideFile}
\alias{b2HideFile}
\title{Hide B2 File.}
\usage{
b2HideFile(bucketId, fileName)
}
\arguments{
\item{bucketId}{The unique identifier of the bucket containing the file to be
hidden. Bucket IDs may be obtained through the \code{b2ListBuckets}
function in this package.}

\item{fileName}{The name of the file to be hidden. File names may be obtained
through the \code{b2ListFileNames} function in this package.}
}
\value{
If successful a list will be returned containing \code{fileId},
  \code{fileName}, \code{action}, \code{size} and \code{uploadTimestamp}.
}
\description{
\code{b2HideFile} hides a file in the user's account on the Backblaze B2
cloud storage product.
}
\details{
This function hides a file in the user's account on the Backblaze B2 cloud
storage product, so that it cannot be downloaded by name. In order to further
understand the concept of B2 file versions, see the speficic Backblaze
documenation. Further details regarding this API call are available here:

\url{https://www.backblaze.com/b2/docs/b2_hide_file.html}
\url{https://www.backblaze.com/b2/docs/file_versions.html}

\code{bucketId} \code{fileName} are mandatory and must be user defined.
}
\examples{
\dontrun{
b2HideFile(bucketId = "aUniqueBucketId", fileName = "yourFileName.txt")
}

}

