% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2UpdateBucket.R
\name{b2UpdateBucket}
\alias{b2UpdateBucket}
\title{Update B2 Bucket.}
\usage{
b2UpdateBucket(bucketId, bucketType)
}
\arguments{
\item{bucketId}{The unique identifier of the bucket to be updated. A list of
all the user's bucket IDs may be found using the \code{b2_list_buckets}
function in this package.}

\item{bucketType}{Supported bucket types are \emph{allPublic} and
\emph{allPrivate}.}
}
\value{
If successful a list containing the \code{accountId},
  \code{bucketId}, \code{bucketName} and \code{bucketType} will all be echoed
  back to the user.
}
\description{
\code{b2UpdateBucket} modifies the bucket type of an existing bucket in the
user's account.
}
\details{
This function modifies the bucket type of an existing bucket, within the
user's account on the Backblaze B2 cloud storage product. This function can
be used to allow everyone to download the contents of the bucket without
providing any authorisation, or to prevent anyone from downloading the
contents of the bucket without providing a bucket \code{authToken}. Further
details regarding this API call are available here:

\url{https://www.backblaze.com/b2/docs/b2_update_bucket.html}

\code{bucketId} and \code{bucketType} are mandatory and must be user defined.
}
\examples{
\dontrun{
# Make a bucket Private
b2UpdateBucket(bucketId = "aUniqueBucketId", bucketType = "allPrivate")
# Make a bucket Public
b2UpdateBucket(bucketId = "aUniqueBucketId", bucketType = "allPublic")
}

}

