% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lans.R
\name{lans}
\alias{lans}
\title{Extract backbone using Locally Adaptive Network Sparsification}
\usage{
lans(
  W,
  alpha = 0.05,
  missing.as.zero = FALSE,
  signed = FALSE,
  mtc = "none",
  class = "original",
  narrative = FALSE
)
}
\arguments{
\item{W}{A positively-weighted unipartite graph, as: (1) an adjacency matrix in the form of a matrix or sparse \code{\link{Matrix}}; (2) an edgelist in the form of a three-column dataframe; (3) an \code{\link{igraph}} object.}

\item{alpha}{real: significance level of hypothesis test(s)}

\item{missing.as.zero}{boolean: should missing edges be treated as edges with zero weight and tested for significance}

\item{signed}{boolean: TRUE for a signed backbone, FALSE for a binary backbone (see details)}

\item{mtc}{string: type of Multiple Test Correction to be applied; can be any method allowed by \code{\link{p.adjust}}.}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "Matrix", "igraph", "edgelist").
If "original", the backbone graph returned is of the same class as \code{W}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
If \code{alpha} != NULL: Binary or signed backbone graph of class \code{class}.

If \code{alpha} == NULL: An S3 backbone object containing (1) the weighted graph as a matrix, (2) upper-tail p-values as a
matrix, (3, if \code{signed = TRUE}) lower-tail p-values as a matrix, (4, if present) node attributes as a dataframe, and
(5) several properties of the original graph and backbone model, from which a backbone can subsequently be extracted
using \code{\link[=backbone.extract]{backbone.extract()}}.
}
\description{
\code{lans} extracts the backbone of a weighted network using Locally Adaptive Network Sparsification
}
\details{
The \code{lans} function applies Locally Adaptive Network Sparsification (LANS; Foti et al., 2011), which compares an edge's
fractional weight to the cumulative distribution function for the fractional edge weights of all edges connected to
a given node. The graph may be directed or undirected, however the edge weights must be positive.

When \code{signed = FALSE}, a one-tailed test (is the weight stronger?) is performed for each edge. The resulting backbone
contains edges whose weights are significantly \emph{stronger} than expected in the null model. When \code{signed = TRUE}, a
two-tailed test (is the weight stronger or weaker?) is performed for each edge. The resulting backbone contains
positive edges for those whose weights are significantly \emph{stronger}, and negative edges for those whose weights are
significantly \emph{weaker}, than expected in the null model.

If \code{W} is an unweighted bipartite graph, then LANS is applied to its weighted bipartite projection.
}
\examples{
#Simple star from Foti et al. (2011), Figure 2
net <- matrix(c(0,2,2,2,2,
                2,0,1,1,0,
                2,1,0,0,1,
                2,1,0,0,1,
                2,0,1,1,0),5,5)
net <- igraph::graph_from_adjacency_matrix(net, mode = "undirected", weighted = TRUE)
plot(net, edge.width = igraph::E(net)$weight^2)

bb <- lans(net, alpha = 0.05, narrative = TRUE) #The LANS backbone
plot(bb)
}
\references{
package: {Neal, Z. P. (2022). backbone: An R Package to Extract Network Backbones. \emph{PLOS ONE, 17}, e0269137. \doi{10.1371/journal.pone.0269137}}

lans: {Foti, N. J., Hughes, J. M., and Rockmore, D. N. (2011). Nonparametric Sparsification of Complex Multiscale Networks. \emph{PLOS One, 6}, e16431. \doi{10.1371/journal.pone.0016431}}
}
