// Generated by rstantools.  Do not edit by hand.

/*
    baggr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    baggr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with baggr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_rubin_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 101> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 50, column 2 to column 35)",
  " (in 'string', line 51, column 2 to column 45)",
  " (in 'string', line 52, column 2 to column 23)",
  " (in 'string', line 53, column 2 to column 18)",
  " (in 'string', line 59, column 2 to column 27)",
  " (in 'string', line 89, column 2 to column 31)",
  " (in 'string', line 90, column 2 to column 27)",
  " (in 'string', line 63, column 4 to column 33)",
  " (in 'string', line 62, column 7 to line 63, column 33)",
  " (in 'string', line 61, column 4 to column 18)",
  " (in 'string', line 60, column 2 to line 63, column 33)",
  " (in 'string', line 95, column 6 to column 30)",
  " (in 'string', line 93, column 6 to column 42)",
  " (in 'string', line 92, column 4 to line 95, column 30)",
  " (in 'string', line 96, column 4 to column 17)",
  " (in 'string', line 99, column 8 to column 108)",
  " (in 'string', line 98, column 6 to line 99, column 108)",
  " (in 'string', line 101, column 8 to column 90)",
  " (in 'string', line 100, column 6 to line 101, column 90)",
  " (in 'string', line 97, column 22 to line 102, column 5)",
  " (in 'string', line 97, column 4 to line 102, column 5)",
  " (in 'string', line 91, column 16 to line 103, column 3)",
  " (in 'string', line 91, column 2 to line 103, column 3)",
  " (in 'string', line 66, column 9 to column 10)",
  " (in 'string', line 66, column 2 to column 17)",
  " (in 'string', line 71, column 6 to column 20)",
  " (in 'string', line 72, column 6 to column 54)",
  " (in 'string', line 70, column 9 to line 73, column 5)",
  " (in 'string', line 69, column 6 to column 32)",
  " (in 'string', line 68, column 15 to line 70, column 5)",
  " (in 'string', line 68, column 4 to line 73, column 5)",
  " (in 'string', line 67, column 11 to line 74, column 3)",
  " (in 'string', line 67, column 2 to line 74, column 3)",
  " (in 'string', line 84, column 4 to column 64)",
  " (in 'string', line 85, column 4 to column 51)",
  " (in 'string', line 83, column 7 to line 86, column 3)",
  " (in 'string', line 79, column 4 to column 64)",
  " (in 'string', line 80, column 4 to column 61)",
  " (in 'string', line 81, column 4 to column 22)",
  " (in 'string', line 82, column 4 to column 53)",
  " (in 'string', line 78, column 29 to line 83, column 3)",
  " (in 'string', line 78, column 8 to line 86, column 3)",
  " (in 'string', line 76, column 4 to column 61)",
  " (in 'string', line 77, column 4 to column 53)",
  " (in 'string', line 75, column 23 to line 78, column 3)",
  " (in 'string', line 75, column 2 to line 86, column 3)",
  " (in 'string', line 25, column 2 to column 19)",
  " (in 'string', line 27, column 2 to column 17)",
  " (in 'string', line 28, column 9 to column 10)",
  " (in 'string', line 28, column 2 to column 24)",
  " (in 'string', line 29, column 18 to column 19)",
  " (in 'string', line 29, column 2 to column 32)",
  " (in 'string', line 30, column 2 to column 18)",
  " (in 'string', line 31, column 9 to column 10)",
  " (in 'string', line 31, column 11 to column 13)",
  " (in 'string', line 31, column 2 to column 17)",
  " (in 'string', line 33, column 2 to column 26)",
  " (in 'string', line 34, column 2 to column 24)",
  " (in 'string', line 35, column 2 to column 21)",
  " (in 'string', line 36, column 2 to column 32)",
  " (in 'string', line 37, column 2 to column 30)",
  " (in 'string', line 38, column 2 to column 27)",
  " (in 'string', line 40, column 2 to column 22)",
  " (in 'string', line 41, column 9 to column 15)",
  " (in 'string', line 41, column 2 to column 34)",
  " (in 'string', line 42, column 18 to column 24)",
  " (in 'string', line 42, column 2 to column 42)",
  " (in 'string', line 43, column 9 to column 15)",
  " (in 'string', line 43, column 16 to column 18)",
  " (in 'string', line 43, column 2 to column 27)",
  " (in 'string', line 46, column 2 to column 43)",
  " (in 'string', line 47, column 9 to column 15)",
  " (in 'string', line 47, column 2 to column 71)",
  " (in 'string', line 50, column 8 to column 25)",
  " (in 'string', line 51, column 8 to column 25)",
  " (in 'string', line 52, column 9 to column 17)",
  " (in 'string', line 53, column 9 to column 11)",
  " (in 'string', line 59, column 9 to column 17)",
  " (in 'string', line 89, column 8 to column 18)",
  " (in 'string', line 90, column 9 to column 15)",
  " (in 'string', line 11, column 9 to column 66)",
  " (in 'string', line 9, column 25 to column 73)",
  " (in 'string', line 9, column 9 to line 11, column 66)",
  " (in 'string', line 6, column 25 to column 70)",
  " (in 'string', line 6, column 9 to line 11, column 66)",
  " (in 'string', line 5, column 25 to column 70)",
  " (in 'string', line 5, column 9 to line 11, column 66)",
  " (in 'string', line 4, column 20 to column 66)",
  " (in 'string', line 4, column 4 to line 11, column 66)",
  " (in 'string', line 3, column 60 to line 12, column 3)",
  " (in 'string', line 20, column 9 to column 66)",
  " (in 'string', line 18, column 25 to column 73)",
  " (in 'string', line 18, column 9 to line 20, column 66)",
  " (in 'string', line 17, column 25 to column 70)",
  " (in 'string', line 17, column 9 to line 20, column 66)",
  " (in 'string', line 16, column 25 to column 70)",
  " (in 'string', line 16, column 9 to line 20, column 66)",
  " (in 'string', line 15, column 20 to column 66)",
  " (in 'string', line 15, column 4 to line 20, column 66)",
  " (in 'string', line 14, column 61 to line 21, column 3)"};
template <bool propto__, typename T0__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
stan::promote_args_t<T0__, stan::base_type_t<T2__>>
realprior_lpdf(const T0__& theta, const int& family, const T2__& pars_arg__,
               std::ostream* pstream__);
template <bool propto__, typename T0__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
stan::promote_args_t<stan::base_type_t<T0__>, stan::base_type_t<T2__>>
vecprior_lpdf(const T0__& theta_arg__, const int& family, const T2__&
              pars_arg__, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
stan::promote_args_t<T0__, stan::base_type_t<T2__>>
realprior_lpdf(const T0__& theta, const int& family, const T2__& pars_arg__,
               std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
                             stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& pars = stan::math::to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 89;
    if (stan::math::logical_eq(family, 0)) {
      current_statement__ = 88;
      return stan::math::uniform_lpdf<false>(theta,
               stan::model::rvalue(pars, "pars", stan::model::index_uni(1)),
               stan::model::rvalue(pars, "pars", stan::model::index_uni(2)));
    } else {
      current_statement__ = 87;
      if (stan::math::logical_eq(family, 1)) {
        current_statement__ = 86;
        return stan::math::normal_lpdf<false>(theta,
                 stan::model::rvalue(pars, "pars", stan::model::index_uni(1)),
                 stan::model::rvalue(pars, "pars", stan::model::index_uni(2)));
      } else {
        current_statement__ = 85;
        if (stan::math::logical_eq(family, 2)) {
          current_statement__ = 84;
          return stan::math::cauchy_lpdf<false>(theta,
                   stan::model::rvalue(pars, "pars",
                     stan::model::index_uni(1)),
                   stan::model::rvalue(pars, "pars",
                     stan::model::index_uni(2)));
        } else {
          current_statement__ = 83;
          if (stan::math::logical_eq(family, 5)) {
            current_statement__ = 82;
            return stan::math::lognormal_lpdf<false>(theta,
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(1)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(2)));
          } else {
            current_statement__ = 81;
            return stan::math::student_t_lpdf<false>(theta,
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(1)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(2)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(3)));
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T0__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
stan::promote_args_t<stan::base_type_t<T0__>, stan::base_type_t<T2__>>
vecprior_lpdf(const T0__& theta_arg__, const int& family, const T2__&
              pars_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& theta = stan::math::to_ref(theta_arg__);
  const auto& pars = stan::math::to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 99;
    if (stan::math::logical_eq(family, 0)) {
      current_statement__ = 98;
      return stan::math::uniform_lpdf<false>(theta,
               stan::model::rvalue(pars, "pars", stan::model::index_uni(1)),
               stan::model::rvalue(pars, "pars", stan::model::index_uni(2)));
    } else {
      current_statement__ = 97;
      if (stan::math::logical_eq(family, 1)) {
        current_statement__ = 96;
        return stan::math::normal_lpdf<false>(theta,
                 stan::model::rvalue(pars, "pars", stan::model::index_uni(1)),
                 stan::model::rvalue(pars, "pars", stan::model::index_uni(2)));
      } else {
        current_statement__ = 95;
        if (stan::math::logical_eq(family, 2)) {
          current_statement__ = 94;
          return stan::math::cauchy_lpdf<false>(theta,
                   stan::model::rvalue(pars, "pars",
                     stan::model::index_uni(1)),
                   stan::model::rvalue(pars, "pars",
                     stan::model::index_uni(2)));
        } else {
          current_statement__ = 93;
          if (stan::math::logical_eq(family, 5)) {
            current_statement__ = 92;
            return stan::math::lognormal_lpdf<false>(theta,
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(1)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(2)));
          } else {
            current_statement__ = 91;
            return stan::math::student_t_lpdf<false>(theta,
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(1)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(2)),
                     stan::model::rvalue(pars, "pars",
                       stan::model::index_uni(3)));
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_rubin final : public model_base_crtp<model_rubin> {
private:
  int pooling_type;
  int K;
  Eigen::Matrix<double,-1,1> theta_hat_k_data__;
  Eigen::Matrix<double,-1,1> se_theta_k_data__;
  int Nc;
  Eigen::Matrix<double,-1,-1> X_data__;
  int prior_hypermean_fam;
  int prior_hypersd_fam;
  int prior_beta_fam;
  Eigen::Matrix<double,-1,1> prior_hypermean_val_data__;
  Eigen::Matrix<double,-1,1> prior_hypersd_val_data__;
  Eigen::Matrix<double,-1,1> prior_beta_val_data__;
  int K_test;
  Eigen::Matrix<double,-1,1> test_theta_hat_k_data__;
  Eigen::Matrix<double,-1,1> test_se_theta_k_data__;
  Eigen::Matrix<double,-1,-1> X_test_data__;
  int K_pooled;
  Eigen::Matrix<double,-1,1> test_var_theta_k_data__;
  int mu_1dim__;
  int tau_1dim__;
  int logpd_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> theta_hat_k{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> se_theta_k{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> prior_hypermean_val{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> prior_hypersd_val{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> prior_beta_val{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> test_theta_hat_k{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> test_se_theta_k{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X_test{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> test_var_theta_k{nullptr, 0};
public:
  ~model_rubin() {}
  model_rubin(stan::io::var_context& context__, unsigned int
              random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_rubin_namespace::model_rubin";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 47;
      context__.validate_dims("data initialization", "pooling_type", "int",
        std::vector<size_t>{});
      pooling_type = std::numeric_limits<int>::min();
      current_statement__ = 47;
      pooling_type = context__.vals_i("pooling_type")[(1 - 1)];
      current_statement__ = 48;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 48;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 48;
      stan::math::check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 49;
      stan::math::validate_non_negative_index("theta_hat_k", "K", K);
      current_statement__ = 50;
      context__.validate_dims("data initialization", "theta_hat_k", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      theta_hat_k_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                             std::numeric_limits<double>::quiet_NaN());
      new (&theta_hat_k)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(theta_hat_k_data__.data(), K);
      {
        std::vector<local_scalar_t__> theta_hat_k_flat__;
        current_statement__ = 50;
        theta_hat_k_flat__ = context__.vals_r("theta_hat_k");
        current_statement__ = 50;
        pos__ = 1;
        current_statement__ = 50;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 50;
          stan::model::assign(theta_hat_k, theta_hat_k_flat__[(pos__ - 1)],
            "assigning variable theta_hat_k", stan::model::index_uni(sym1__));
          current_statement__ = 50;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 51;
      stan::math::validate_non_negative_index("se_theta_k", "K", K);
      current_statement__ = 52;
      context__.validate_dims("data initialization", "se_theta_k", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      se_theta_k_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                            std::numeric_limits<double>::quiet_NaN());
      new (&se_theta_k)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(se_theta_k_data__.data(), K);
      {
        std::vector<local_scalar_t__> se_theta_k_flat__;
        current_statement__ = 52;
        se_theta_k_flat__ = context__.vals_r("se_theta_k");
        current_statement__ = 52;
        pos__ = 1;
        current_statement__ = 52;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 52;
          stan::model::assign(se_theta_k, se_theta_k_flat__[(pos__ - 1)],
            "assigning variable se_theta_k", stan::model::index_uni(sym1__));
          current_statement__ = 52;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 52;
      stan::math::check_greater_or_equal(function__, "se_theta_k",
        se_theta_k, 0);
      current_statement__ = 53;
      context__.validate_dims("data initialization", "Nc", "int",
        std::vector<size_t>{});
      Nc = std::numeric_limits<int>::min();
      current_statement__ = 53;
      Nc = context__.vals_i("Nc")[(1 - 1)];
      current_statement__ = 53;
      stan::math::check_greater_or_equal(function__, "Nc", Nc, 0);
      current_statement__ = 54;
      stan::math::validate_non_negative_index("X", "K", K);
      current_statement__ = 55;
      stan::math::validate_non_negative_index("X", "Nc", Nc);
      current_statement__ = 56;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(K), static_cast<size_t>(Nc)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(K, Nc,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), K,
        Nc);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 56;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 56;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 56;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 56;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 57;
      context__.validate_dims("data initialization", "prior_hypermean_fam",
        "int", std::vector<size_t>{});
      prior_hypermean_fam = std::numeric_limits<int>::min();
      current_statement__ = 57;
      prior_hypermean_fam = context__.vals_i("prior_hypermean_fam")[(1 - 1)];
      current_statement__ = 58;
      context__.validate_dims("data initialization", "prior_hypersd_fam",
        "int", std::vector<size_t>{});
      prior_hypersd_fam = std::numeric_limits<int>::min();
      current_statement__ = 58;
      prior_hypersd_fam = context__.vals_i("prior_hypersd_fam")[(1 - 1)];
      current_statement__ = 59;
      context__.validate_dims("data initialization", "prior_beta_fam", "int",
        std::vector<size_t>{});
      prior_beta_fam = std::numeric_limits<int>::min();
      current_statement__ = 59;
      prior_beta_fam = context__.vals_i("prior_beta_fam")[(1 - 1)];
      current_statement__ = 60;
      context__.validate_dims("data initialization", "prior_hypermean_val",
        "double", std::vector<size_t>{static_cast<size_t>(3)});
      prior_hypermean_val_data__ = Eigen::Matrix<double,-1,1>::Constant(3,
                                     std::numeric_limits<double>::quiet_NaN());
      new (&prior_hypermean_val)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(prior_hypermean_val_data__.data(),
        3);
      {
        std::vector<local_scalar_t__> prior_hypermean_val_flat__;
        current_statement__ = 60;
        prior_hypermean_val_flat__ = context__.vals_r("prior_hypermean_val");
        current_statement__ = 60;
        pos__ = 1;
        current_statement__ = 60;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 60;
          stan::model::assign(prior_hypermean_val,
            prior_hypermean_val_flat__[(pos__ - 1)],
            "assigning variable prior_hypermean_val",
            stan::model::index_uni(sym1__));
          current_statement__ = 60;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 61;
      context__.validate_dims("data initialization", "prior_hypersd_val",
        "double", std::vector<size_t>{static_cast<size_t>(3)});
      prior_hypersd_val_data__ = Eigen::Matrix<double,-1,1>::Constant(3,
                                   std::numeric_limits<double>::quiet_NaN());
      new (&prior_hypersd_val)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(prior_hypersd_val_data__.data(),
        3);
      {
        std::vector<local_scalar_t__> prior_hypersd_val_flat__;
        current_statement__ = 61;
        prior_hypersd_val_flat__ = context__.vals_r("prior_hypersd_val");
        current_statement__ = 61;
        pos__ = 1;
        current_statement__ = 61;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 61;
          stan::model::assign(prior_hypersd_val,
            prior_hypersd_val_flat__[(pos__ - 1)],
            "assigning variable prior_hypersd_val",
            stan::model::index_uni(sym1__));
          current_statement__ = 61;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 62;
      context__.validate_dims("data initialization", "prior_beta_val",
        "double", std::vector<size_t>{static_cast<size_t>(3)});
      prior_beta_val_data__ = Eigen::Matrix<double,-1,1>::Constant(3,
                                std::numeric_limits<double>::quiet_NaN());
      new (&prior_beta_val)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(prior_beta_val_data__.data(),
        3);
      {
        std::vector<local_scalar_t__> prior_beta_val_flat__;
        current_statement__ = 62;
        prior_beta_val_flat__ = context__.vals_r("prior_beta_val");
        current_statement__ = 62;
        pos__ = 1;
        current_statement__ = 62;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 62;
          stan::model::assign(prior_beta_val, prior_beta_val_flat__[(pos__ -
            1)], "assigning variable prior_beta_val",
            stan::model::index_uni(sym1__));
          current_statement__ = 62;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 63;
      context__.validate_dims("data initialization", "K_test", "int",
        std::vector<size_t>{});
      K_test = std::numeric_limits<int>::min();
      current_statement__ = 63;
      K_test = context__.vals_i("K_test")[(1 - 1)];
      current_statement__ = 63;
      stan::math::check_greater_or_equal(function__, "K_test", K_test, 0);
      current_statement__ = 64;
      stan::math::validate_non_negative_index("test_theta_hat_k", "K_test",
        K_test);
      current_statement__ = 65;
      context__.validate_dims("data initialization", "test_theta_hat_k",
        "double", std::vector<size_t>{static_cast<size_t>(K_test)});
      test_theta_hat_k_data__ = Eigen::Matrix<double,-1,1>::Constant(K_test,
                                  std::numeric_limits<double>::quiet_NaN());
      new (&test_theta_hat_k)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(test_theta_hat_k_data__.data(),
        K_test);
      {
        std::vector<local_scalar_t__> test_theta_hat_k_flat__;
        current_statement__ = 65;
        test_theta_hat_k_flat__ = context__.vals_r("test_theta_hat_k");
        current_statement__ = 65;
        pos__ = 1;
        current_statement__ = 65;
        for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
          current_statement__ = 65;
          stan::model::assign(test_theta_hat_k,
            test_theta_hat_k_flat__[(pos__ - 1)],
            "assigning variable test_theta_hat_k",
            stan::model::index_uni(sym1__));
          current_statement__ = 65;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 66;
      stan::math::validate_non_negative_index("test_se_theta_k", "K_test",
        K_test);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "test_se_theta_k",
        "double", std::vector<size_t>{static_cast<size_t>(K_test)});
      test_se_theta_k_data__ = Eigen::Matrix<double,-1,1>::Constant(K_test,
                                 std::numeric_limits<double>::quiet_NaN());
      new (&test_se_theta_k)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(test_se_theta_k_data__.data(),
        K_test);
      {
        std::vector<local_scalar_t__> test_se_theta_k_flat__;
        current_statement__ = 67;
        test_se_theta_k_flat__ = context__.vals_r("test_se_theta_k");
        current_statement__ = 67;
        pos__ = 1;
        current_statement__ = 67;
        for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
          current_statement__ = 67;
          stan::model::assign(test_se_theta_k, test_se_theta_k_flat__[(pos__
            - 1)], "assigning variable test_se_theta_k",
            stan::model::index_uni(sym1__));
          current_statement__ = 67;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 67;
      stan::math::check_greater_or_equal(function__, "test_se_theta_k",
        test_se_theta_k, 0);
      current_statement__ = 68;
      stan::math::validate_non_negative_index("X_test", "K_test", K_test);
      current_statement__ = 69;
      stan::math::validate_non_negative_index("X_test", "Nc", Nc);
      current_statement__ = 70;
      context__.validate_dims("data initialization", "X_test", "double",
        std::vector<size_t>{static_cast<size_t>(K_test),
          static_cast<size_t>(Nc)});
      X_test_data__ = Eigen::Matrix<double,-1,-1>::Constant(K_test, Nc,
                        std::numeric_limits<double>::quiet_NaN());
      new (&X_test)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_test_data__.data(), K_test,
        Nc);
      {
        std::vector<local_scalar_t__> X_test_flat__;
        current_statement__ = 70;
        X_test_flat__ = context__.vals_r("X_test");
        current_statement__ = 70;
        pos__ = 1;
        current_statement__ = 70;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 70;
          for (int sym2__ = 1; sym2__ <= K_test; ++sym2__) {
            current_statement__ = 70;
            stan::model::assign(X_test, X_test_flat__[(pos__ - 1)],
              "assigning variable X_test", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 70;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 71;
      K_pooled = std::numeric_limits<int>::min();
      current_statement__ = 71;
      K_pooled = (stan::math::logical_eq(pooling_type, 2) ? 0 : K);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("test_var_theta_k", "K_test",
        K_test);
      current_statement__ = 73;
      test_var_theta_k_data__ = Eigen::Matrix<double,-1,1>::Constant(K_test,
                                  std::numeric_limits<double>::quiet_NaN());
      new (&test_var_theta_k)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(test_var_theta_k_data__.data(),
        K_test);
      current_statement__ = 73;
      stan::model::assign(test_var_theta_k,
        stan::math::elt_multiply(test_se_theta_k, test_se_theta_k),
        "assigning variable test_var_theta_k");
      current_statement__ = 74;
      mu_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 74;
      mu_1dim__ = stan::math::logical_neq(pooling_type, 0);
      current_statement__ = 74;
      stan::math::validate_non_negative_index("mu", "pooling_type != 0",
        mu_1dim__);
      current_statement__ = 75;
      tau_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 75;
      tau_1dim__ = stan::math::logical_eq(pooling_type, 1);
      current_statement__ = 75;
      stan::math::validate_non_negative_index("tau", "pooling_type == 1",
        tau_1dim__);
      current_statement__ = 76;
      stan::math::validate_non_negative_index("eta", "K_pooled", K_pooled);
      current_statement__ = 77;
      stan::math::validate_non_negative_index("beta", "Nc", Nc);
      current_statement__ = 78;
      stan::math::validate_non_negative_index("theta_k", "K_pooled", K_pooled);
      current_statement__ = 79;
      logpd_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 79;
      logpd_1dim__ = stan::math::logical_gt(K_test, 0);
      current_statement__ = 79;
      stan::math::validate_non_negative_index("logpd", "K_test > 0",
        logpd_1dim__);
      current_statement__ = 80;
      stan::math::validate_non_negative_index("fe_k_test", "K_test", K_test);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = mu_1dim__ + tau_1dim__ + K_pooled + Nc;
  }
  inline std::string model_name() const final {
    return "model_rubin";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_rubin_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<local_scalar_t__> mu =
        std::vector<local_scalar_t__>(mu_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      mu = in__.template read<std::vector<local_scalar_t__>>(mu_1dim__);
      std::vector<local_scalar_t__> tau =
        std::vector<local_scalar_t__>(tau_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      tau = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
              jacobian__>(0, lp__, tau_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K_pooled, DUMMY_VAR__);
      current_statement__ = 3;
      eta = in__.template read<
              Eigen::Matrix<local_scalar_t__,-1,1>>(K_pooled);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(Nc, DUMMY_VAR__);
      current_statement__ = 4;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(Nc);
      Eigen::Matrix<local_scalar_t__,-1,1> theta_k =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K_pooled, DUMMY_VAR__);
      current_statement__ = 11;
      if (stan::math::logical_eq(pooling_type, 0)) {
        current_statement__ = 10;
        stan::model::assign(theta_k, eta, "assigning variable theta_k");
      } else {
        current_statement__ = 9;
        if (stan::math::logical_eq(pooling_type, 1)) {
          current_statement__ = 8;
          stan::model::assign(theta_k,
            stan::math::add(
              stan::model::rvalue(mu, "mu", stan::model::index_uni(1)),
              stan::math::multiply(eta,
                stan::model::rvalue(tau, "tau", stan::model::index_uni(1)))),
            "assigning variable theta_k");
        }
      }
      {
        current_statement__ = 24;
        stan::math::validate_non_negative_index("fe_k", "K", K);
        Eigen::Matrix<local_scalar_t__,-1,1> fe_k =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
        current_statement__ = 33;
        if (stan::math::logical_gt(K, 0)) {
          current_statement__ = 31;
          if (stan::math::logical_eq(Nc, 0)) {
            current_statement__ = 29;
            stan::model::assign(fe_k, stan::math::rep_vector(0.0, K),
              "assigning variable fe_k");
          } else {
            current_statement__ = 26;
            stan::model::assign(fe_k, stan::math::multiply(X, beta),
              "assigning variable fe_k");
            current_statement__ = 27;
            lp_accum__.add(vecprior_lpdf<propto__>(beta, prior_beta_fam,
                             prior_beta_val, pstream__));
          }
        }
        current_statement__ = 46;
        if (stan::math::logical_eq(pooling_type, 0)) {
          current_statement__ = 43;
          lp_accum__.add(vecprior_lpdf<propto__>(eta, prior_hypermean_fam,
                           prior_hypermean_val, pstream__));
          current_statement__ = 44;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(theta_hat_k,
                           stan::math::add(theta_k, fe_k), se_theta_k));
        } else {
          current_statement__ = 42;
          if (stan::math::logical_eq(pooling_type, 1)) {
            current_statement__ = 37;
            lp_accum__.add(realprior_lpdf<propto__>(
                             stan::model::rvalue(mu, "mu",
                               stan::model::index_uni(1)),
                             prior_hypermean_fam, prior_hypermean_val,
                             pstream__));
            current_statement__ = 38;
            lp_accum__.add(realprior_lpdf<propto__>(
                             stan::model::rvalue(tau, "tau",
                               stan::model::index_uni(1)), prior_hypersd_fam,
                             prior_hypersd_val, pstream__));
            current_statement__ = 39;
            lp_accum__.add(stan::math::normal_lpdf<propto__>(eta, 0, 1));
            current_statement__ = 40;
            lp_accum__.add(stan::math::normal_lpdf<propto__>(theta_hat_k,
                             stan::math::add(theta_k, fe_k), se_theta_k));
          } else {
            current_statement__ = 34;
            lp_accum__.add(realprior_lpdf<propto__>(
                             stan::model::rvalue(mu, "mu",
                               stan::model::index_uni(1)),
                             prior_hypermean_fam, prior_hypermean_val,
                             pstream__));
            current_statement__ = 35;
            lp_accum__.add(stan::math::normal_lpdf<propto__>(theta_hat_k,
                             stan::math::add(
                               stan::model::rvalue(mu, "mu",
                                 stan::model::index_uni(1)), fe_k),
                             se_theta_k));
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_rubin_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<double> mu =
        std::vector<double>(mu_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      mu = in__.template read<std::vector<local_scalar_t__>>(mu_1dim__);
      std::vector<double> tau =
        std::vector<double>(tau_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      tau = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
              jacobian__>(0, lp__, tau_1dim__);
      Eigen::Matrix<double,-1,1> eta =
        Eigen::Matrix<double,-1,1>::Constant(K_pooled,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      eta = in__.template read<
              Eigen::Matrix<local_scalar_t__,-1,1>>(K_pooled);
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(Nc,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(Nc);
      Eigen::Matrix<double,-1,1> theta_k =
        Eigen::Matrix<double,-1,1>::Constant(K_pooled,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(mu);
      out__.write(tau);
      out__.write(eta);
      out__.write(beta);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 11;
      if (stan::math::logical_eq(pooling_type, 0)) {
        current_statement__ = 10;
        stan::model::assign(theta_k, eta, "assigning variable theta_k");
      } else {
        current_statement__ = 9;
        if (stan::math::logical_eq(pooling_type, 1)) {
          current_statement__ = 8;
          stan::model::assign(theta_k,
            stan::math::add(
              stan::model::rvalue(mu, "mu", stan::model::index_uni(1)),
              stan::math::multiply(eta,
                stan::model::rvalue(tau, "tau", stan::model::index_uni(1)))),
            "assigning variable theta_k");
        }
      }
      if (emit_transformed_parameters__) {
        out__.write(theta_k);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<double> logpd =
        std::vector<double>(logpd_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> fe_k_test =
        Eigen::Matrix<double,-1,1>::Constant(K_test,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 23;
      if (stan::math::logical_gt(K_test, 0)) {
        current_statement__ = 14;
        if (stan::math::logical_eq(Nc, 0)) {
          current_statement__ = 13;
          stan::model::assign(fe_k_test, stan::math::rep_vector(0.0, K_test),
            "assigning variable fe_k_test");
        } else {
          current_statement__ = 12;
          stan::model::assign(fe_k_test, stan::math::multiply(X_test, beta),
            "assigning variable fe_k_test");
        }
        current_statement__ = 15;
        stan::model::assign(logpd, 0, "assigning variable logpd",
          stan::model::index_uni(1));
        current_statement__ = 21;
        for (int k = 1; k <= K_test; ++k) {
          current_statement__ = 17;
          if (stan::math::logical_eq(pooling_type, 1)) {
            current_statement__ = 16;
            stan::model::assign(logpd,
              (stan::model::rvalue(logpd, "logpd", stan::model::index_uni(1))
              +
              stan::math::normal_lpdf<false>(
                stan::model::rvalue(test_theta_hat_k, "test_theta_hat_k",
                  stan::model::index_uni(k)),
                stan::math::add(
                  stan::model::rvalue(mu, "mu", stan::model::index_uni(1)),
                  fe_k_test),
                stan::math::sqrt(
                  stan::math::add(
                    stan::math::pow(
                      stan::model::rvalue(tau, "tau",
                        stan::model::index_uni(1)), 2), test_var_theta_k)))),
              "assigning variable logpd", stan::model::index_uni(1));
          }
          current_statement__ = 19;
          if (stan::math::logical_eq(pooling_type, 2)) {
            current_statement__ = 18;
            stan::model::assign(logpd,
              (stan::model::rvalue(logpd, "logpd", stan::model::index_uni(1))
              +
              stan::math::normal_lpdf<false>(
                stan::model::rvalue(test_theta_hat_k, "test_theta_hat_k",
                  stan::model::index_uni(k)),
                stan::math::add(
                  stan::model::rvalue(mu, "mu", stan::model::index_uni(1)),
                  fe_k_test), test_se_theta_k)), "assigning variable logpd",
              stan::model::index_uni(1));
          }
        }
      }
      out__.write(logpd);
      out__.write(fe_k_test);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> mu =
        std::vector<local_scalar_t__>(mu_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(mu,
        in__.read<std::vector<local_scalar_t__>>(mu_1dim__),
        "assigning variable mu");
      out__.write(mu);
      std::vector<local_scalar_t__> tau =
        std::vector<local_scalar_t__>(tau_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(tau,
        in__.read<std::vector<local_scalar_t__>>(tau_1dim__),
        "assigning variable tau");
      out__.write_free_lb(0, tau);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K_pooled, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(eta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K_pooled),
        "assigning variable eta");
      out__.write(eta);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(Nc, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(Nc),
        "assigning variable beta");
      out__.write(beta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "mu", "double",
        std::vector<size_t>{static_cast<size_t>(mu_1dim__)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "tau", "double",
        std::vector<size_t>{static_cast<size_t>(tau_1dim__)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "eta", "double",
        std::vector<size_t>{static_cast<size_t>(K_pooled)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(Nc)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> mu =
        std::vector<local_scalar_t__>(mu_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      mu = context__.vals_r("mu");
      out__.write(mu);
      std::vector<local_scalar_t__> tau =
        std::vector<local_scalar_t__>(tau_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      tau = context__.vals_r("tau");
      out__.write_free_lb(0, tau);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K_pooled, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> eta_flat__;
        current_statement__ = 3;
        eta_flat__ = context__.vals_r("eta");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
          current_statement__ = 3;
          stan::model::assign(eta, eta_flat__[(pos__ - 1)],
            "assigning variable eta", stan::model::index_uni(sym1__));
          current_statement__ = 3;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(eta);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(Nc, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 4;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 4;
          stan::model::assign(beta, beta_flat__[(pos__ - 1)],
            "assigning variable beta", stan::model::index_uni(sym1__));
          current_statement__ = 4;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"mu", "tau", "eta", "beta"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"theta_k"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"logpd", "fe_k_test"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    mu_1dim__)},
                std::vector<size_t>{static_cast<size_t>(tau_1dim__)},
                std::vector<size_t>{static_cast<size_t>(K_pooled)},
                std::vector<size_t>{static_cast<size_t>(Nc)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(K_pooled)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(logpd_1dim__)},
             std::vector<size_t>{static_cast<size_t>(K_test)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "mu" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "tau" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
      param_names__.emplace_back(std::string() + "eta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
        param_names__.emplace_back(std::string() + "theta_k" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "logpd" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
        param_names__.emplace_back(std::string() + "fe_k_test" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "mu" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= tau_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "tau" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
      param_names__.emplace_back(std::string() + "eta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K_pooled; ++sym1__) {
        param_names__.emplace_back(std::string() + "theta_k" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "logpd" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
        param_names__.emplace_back(std::string() + "fe_k_test" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(mu_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(tau_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K_pooled) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(Nc) + "},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K_pooled) + "},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(logpd_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"fe_k_test\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K_test) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(mu_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(tau_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K_pooled) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(Nc) + "},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K_pooled) + "},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(logpd_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"fe_k_test\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K_test) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((mu_1dim__ + tau_1dim__) + K_pooled) + Nc);
    const size_t num_transformed = emit_transformed_parameters * (K_pooled);
    const size_t num_gen_quantities = emit_generated_quantities *
      ((logpd_1dim__ + K_test));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((mu_1dim__ + tau_1dim__) + K_pooled) + Nc);
    const size_t num_transformed = emit_transformed_parameters * (K_pooled);
    const size_t num_gen_quantities = emit_generated_quantities *
      ((logpd_1dim__ + K_test));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_rubin_namespace::model_rubin;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_rubin_namespace::profiles__;
}
#endif
#endif
