% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-etiology-regression.R
\name{plot_etiology_regression}
\alias{plot_etiology_regression}
\title{visualize the etiology regression with a continuous covariate}
\usage{
plot_etiology_regression(
  DIR_NPLCM,
  stratum_bool,
  slice = 1,
  plot_basis = FALSE,
  truth = NULL,
  RES_NPLCM = NULL,
  do_plot = TRUE,
  do_rug = TRUE,
  return_metric = TRUE,
  plot_ma_dots = FALSE
)
}
\arguments{
\item{DIR_NPLCM}{File path to the folder containing posterior samples}

\item{stratum_bool}{a vector of TRUE/FALSE with TRUE indicating the rows of subjects to include}

\item{slice}{integer; specifies which slice of bronze-standard data to visualize; Default to 1.}

\item{plot_basis}{TRUE for plotting basis functions; Default to FALSE}

\item{truth}{a list of truths computed from true parameters in simulations; elements:
Eti, FPR, PR_case,TPR; All default to \code{NULL} in real data analyses.
Currently only works for one slice of bronze-standard measurements (in a non-nested model).
\itemize{
\item Eti matrix of # of rows = # of subjects, # columns: \code{length(cause_list)} for Eti
\item FPR matrix of # of rows = # of subjects, # columns: \code{ncol(data_nplcm$Mobs$MBS$MBS1)}
\item PR_case matrix of # of rows = # of subjects, # columns: \code{ncol(data_nplcm$Mobs$MBS$MBS1)}
\item TPR a vector of length identical to \code{PR_case}
}}

\item{RES_NPLCM}{pre-read res_nplcm; default to NULL.}

\item{do_plot}{TRUE for plotting}

\item{do_rug}{TRUE for plotting}

\item{return_metric}{TRUE for showing overall mean etiology, quantiles, s.d., and if \code{truth$Eti} is supplied,
coverage, bias, truth and integrated mean squared errors (IMSE).}

\item{plot_ma_dots}{plot moving averages among case and controls if TRUE; Default to FALSE.}
}
\value{
A figure of etiology regression curves and some marginal positive rate assessment of
model fit; See example for the legends.
}
\description{
This function visualizes the etiology regression against one continuous covariate, e.g.,
enrollment date. (NB: dealing with NoA, multiple-pathogen causes, other continuous covariates?
also there this function only plots the first slice - so generalization may be useful - give
users an option to choose slice s; currently default to the first slice.)
}
\references{
See example figures
\itemize{
\item A Figure using simulated data for six pathogens:
\url{https://github.com/zhenkewu/baker/blob/master/inst/figs/visualize_etiology_regression_SITE=1.pdf}
\item The legends for the figure above:
\url{https://github.com/zhenkewu/baker/blob/master/inst/figs/legends_visualize_etiology_regression.png}
}
}
\seealso{
Other visualization functions: 
\code{\link{plot.nplcm}()},
\code{\link{plot_BrS_panel}()},
\code{\link{plot_SS_panel}()},
\code{\link{plot_check_common_pattern}()},
\code{\link{plot_check_pairwise_SLORD}()},
\code{\link{plot_etiology_strat}()},
\code{\link{plot_panels}()},
\code{\link{plot_pie_panel}()},
\code{\link{plot_subwt_regression}()}
}
\concept{visualization functions}
