/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import bartMachine.TreeIllustration;
import bartMachine.bartMachineTreeNode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class TreeArrayIllustration {
    private int sample_num;
    private ArrayList<bartMachineTreeNode> trees;
    private ArrayList<Double> likelihoods;
    private String unique_name;
    public static NumberFormat one_digit_format = NumberFormat.getInstance();
    private static final String ZEROES = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";

    public TreeArrayIllustration(int n, String string) {
        this.sample_num = n;
        this.unique_name = string;
        this.trees = new ArrayList();
        this.likelihoods = new ArrayList();
    }

    public void AddTree(bartMachineTreeNode bartMachineTreeNode2) {
        this.trees.add(bartMachineTreeNode2);
    }

    public void addLikelihood(double d) {
        this.likelihoods.add(d);
    }

    public synchronized void CreateIllustrationAndSaveImage() {
        BufferedImage bufferedImage;
        int n = this.trees.size();
        int n2 = 0;
        int n3 = Integer.MIN_VALUE;
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(n);
        for (int i = 0; i < n; ++i) {
            bartMachineTreeNode bartMachineTreeNode2 = this.trees.get(i);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("tree_num", "" + (i + 1));
            hashMap.put("num_iteration", "" + this.sample_num);
            bufferedImage = new TreeIllustration(bartMachineTreeNode2, hashMap).getCanvas();
            n2 += bufferedImage.getWidth();
            if (bufferedImage.getHeight() > n3) {
                n3 = bufferedImage.getHeight();
            }
            arrayList.add(bufferedImage);
        }
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 12);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            bufferedImage = (BufferedImage)arrayList.get(i);
            bufferedImage2.getGraphics().drawImage(bufferedImage, n4, 0, null);
            n4 += bufferedImage.getWidth();
        }
        this.saveImageFile(bufferedImage2);
    }

    private void saveImageFile(BufferedImage bufferedImage) {
        String string = "BART_" + this.unique_name + "_iter_" + TreeArrayIllustration.LeadingZeroes(this.sample_num, 5);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(string + ".png"));
        }
        catch (IOException iOException) {
            System.err.println("can't save " + string);
        }
    }

    public static String LeadingZeroes(double d, int n) {
        if (d < 10.0 && n >= 2) {
            return ZEROES.substring(0, n - 1) + d;
        }
        if (d < 100.0 && n >= 3) {
            return ZEROES.substring(0, n - 2) + d;
        }
        if (d < 1000.0 && n >= 4) {
            return ZEROES.substring(0, n - 3) + d;
        }
        if (d < 10000.0 && n >= 5) {
            return ZEROES.substring(0, n - 4) + d;
        }
        if (d < 100000.0 && n >= 6) {
            return ZEROES.substring(0, n - 5) + d;
        }
        if (d < 1000000.0 && n >= 7) {
            return ZEROES.substring(0, n - 6) + d;
        }
        if (d < 1.0E7 && n >= 8) {
            return ZEROES.substring(0, n - 7) + d;
        }
        return String.valueOf(d);
    }

    public static String LeadingZeroes(int n, int n2) {
        if (n < 10 && n2 >= 2) {
            return ZEROES.substring(0, n2 - 1) + n;
        }
        if (n < 100 && n2 >= 3) {
            return ZEROES.substring(0, n2 - 2) + n;
        }
        if (n < 1000 && n2 >= 4) {
            return ZEROES.substring(0, n2 - 3) + n;
        }
        if (n < 10000 && n2 >= 5) {
            return ZEROES.substring(0, n2 - 4) + n;
        }
        if (n < 100000 && n2 >= 6) {
            return ZEROES.substring(0, n2 - 5) + n;
        }
        if (n < 1000000 && n2 >= 7) {
            return ZEROES.substring(0, n2 - 6) + n;
        }
        if (n < 10000000 && n2 >= 8) {
            return ZEROES.substring(0, n2 - 7) + n;
        }
        return String.valueOf(n);
    }

    static {
        one_digit_format.setMaximumFractionDigits(1);
    }
}

