% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimpBart.R
\name{vimpBart}
\alias{vimpBart}
\title{vimpBart}
\usage{
vimpBart(trees, type = "prop")
}
\arguments{
\item{trees}{A data frame created by `extractTreeData` function.}

\item{type}{What value to return. Either the raw count 'val', the proportion 'prop',
the column means of the proportions 'propMean', or the median of the proportions 'propMedian'.}
}
\value{
A matrix of importance values
}
\description{
A matrix with nMCMC rows with each variable as a column.
Each row represents an MCMC iteration. For each variable, the total count
of the number of times that variable is used in a tree is given.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6], df[, 1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 vimpBart(trees_data, type = 'prop')
 }
}
