% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_team_leaders.R
\name{mlb_team_leaders}
\alias{mlb_team_leaders}
\title{\strong{MLB Team Leaders}}
\usage{
mlb_team_leaders(
  team_id = NULL,
  leader_categories = NULL,
  leader_game_types = NULL,
  season = NULL,
  limit = 1000
)
}
\arguments{
\item{team_id}{Team ID to return team leader information for.}

\item{leader_categories}{Team leader category to return information and ranking for a particular statistic.}

\item{leader_game_types}{Game type to return information and ranking for a particular statistic in a particular game type.}

\item{season}{Season to return team leader information for.}

\item{limit}{A limit to limit return to a particular number of records.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   leader_category \tab character \cr
   rank \tab integer \cr
   value \tab character \cr
   season \tab character \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_link \tab character \cr
   league_id \tab integer \cr
   league_name \tab character \cr
   league_link \tab character \cr
   person_id \tab integer \cr
   person_full_name \tab character \cr
   person_link \tab character \cr
   person_first_name \tab character \cr
   person_last_name \tab character \cr
   sport_id \tab integer \cr
   sport_link \tab character \cr
   sport_abbreviation \tab character \cr
   stat_group \tab character \cr
   total_splits \tab integer \cr
   game_type_id \tab character \cr
   game_type_description \tab character \cr
}
}
\description{
\strong{MLB Team Leaders}
}
\examples{
\donttest{
  try(mlb_team_leaders(team_id = 137, leader_categories = "homeRuns", season = 2021))
}
}
