% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitHillModel.R
\name{fitHillModel}
\alias{fitHillModel}
\title{Fit a Hill dose response model to data}
\usage{
fitHillModel(
  conc,
  act,
  model,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL
)
}
\arguments{
\item{conc}{A vector concentration values (including 0 or Inf)}

\item{act}{A vector response values the same length as \code{conc}}

\item{model}{A vector of values between 1 and 4, specifying the precise
model to be fit. The values correspond to the four parameters of the Hill
model: dose of median effect, Hill slope, minimal effect, and maximal effect
(see \code{\link[=evalHillModel]{evalHillModel()}}).  The first of these two are always fit, so \code{model}
must contain at least \code{1} and \code{2}.  The presence of \code{3} or \code{4} will determine
if those parameters are also fit, or fixed at the given starting value. So
\code{c(1,2,4)} will fit the dose of median effect, the Hill slope, and the
maximal effect, but will leave the minimal effect fixed at the starting
value.}

\item{start}{A vector of four starting values for the Hill model to be fit.
Any values not being fit will be fixed at these starting values.  If left as
\code{NULL}, a starting vector will be estimated from the data, but it will almost
always be better to provide an explicit staring model.}

\item{direction}{Determines the possible directionality of the dose response
model.  If 0 (the default) no additional constraints are placed on the
parameters.  If greater than 0, the fitting will require that the maximal
effect is \emph{greater} than the minimal effect.  If less than 0, the fitting
wll require tha the maximal effect is \emph{less} than the minimal effect.}

\item{lower}{A vector of lower bounds on the Hill parameter values.  Can be
the same length as \code{model} (in which case the bounds will be applied to the
corresponding fit parameters) or the full length of 4.  Any parameters for
which you do not wish to specify a bound can be set to \code{NA}.}

\item{upper}{A vector of upper bounds on the Hill parameter values.  Works
the same as parameter \code{lower}.}
}
\value{
An object of class \code{hillrm}, containing the following values:
\itemize{
\item \code{conc}: the given vector of concentraitons
\item \code{act}: the given vector of responses
\item \code{coefficients}: the full four-parameter Hill parameter vector (accessible
by the function \code{coef()})
\item \code{par}: the vector of paramters that were actually fit
\item \code{fitted.values}: the predicted responses of the best fit model (accessible
by the functoin \code{fitted()})
\item \code{residuals}: the difference between the actual responses and the predicted
responses (accessible by the function \code{residuals()})
\item \code{model}: the vector of values between 1 and 4 specifying the precise model
that was fit
\item \code{mname}: a character string naming the precise model that was fit. One of
"m2p", "m3plc", "m3puc", or "m4p"
\item \code{start}: a four-value parameter vector used as the starting value for the
model fit
\item \code{direction}: the direction constraint used in the fit
\item \code{pbounds}: a two-by-four matrix of values specifying the lower and upper
bounds used in the fit
}
}
\description{
This function uses the R \code{stats} function \code{optim} to fit a Hill dose
response model to a given set of dose and response values.  Four different
model settings are allowed, in which the minimal and maximal effects are
either fixed at a provided value or allowed to be fit to the data.
}
\examples{
conc <- c(0,2^(-6:3),Inf)
hpar <- c(1,3,0,75)
response <- evalHillModel(conc, hpar) + rnorm(length(conc),sd=7.5)

hfit <- fitHillModel(conc,response,c(1,2,3,4),start=c(0.5,1,0,100))
hfit2 <- fitHillModel(conc,response,c(1,2,4),start=c(0.5,1,0,100),
                      direction=0,lower=c(NA,NA,0,0))
}
