% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableCells.R
\docType{class}
\name{TableCells}
\alias{TableCells}
\title{A class that contains the cells from a table.}
\format{\code{\link{R6Class}} object.}
\usage{
TableCells
}
\value{
Object of \code{\link{R6Class}} with properties and methods relating
  to the cells of a table.
}
\description{
The TableCells class contains all of the TableCell objects that comprise a
table.
}
\section{Fields}{

\describe{
\item{\code{parentTable}}{Owning table.}

\item{\code{rows}}{The rows of cells in the table.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new set of table cells, specifying
  the field values documented above.}
  \item{\code{reset())}}{Clears and removes all of the cells.}
  \item{\code{getCell(r, c))}}{Get the TableCell at the specified row and
  column coordinates in the table.}
  \item{\code{getValue(r, c))}}{Get the value at the specified row and
  column coordinates in the table.}
  \item{\code{getRowValues(rowNumber=NULL, columnNumbers=NULL,
  formattedValue=FALSE, asList=FALSE, rebase=TRUE)}}{Get a vector or list of
  the values in a row.}
  \item{\code{getColumnValues(columnNumber=NULL, rowNumbers=NULL,
  formattedValue=FALSE, asList=FALSE, rebase=TRUE)}}{Get a vector or list of
  the values in a column.}
  \item{\code{setCell(r, c, cellType="cell", rawValue=NULL,
  formattedValue=NULL, visible=TRUE, baseStyleName=NULL,
  styleDeclarations=NULL, rowSpan=NULL, colSpan=NULL)}}{Set the details of a
  cell in the table.}
  \item{\code{setBlankCell(r, c, cellType="cell", visible=TRUE,
  baseStyleName=NULL, styleDeclarations=NULL, rowSpan=NULL,
  colSpan=NULL)}}{Set a cell to be empty in the table.}
  \item{\code{deleteCell(r, c)}}{Remove a cell from the table (replacing it
  with a blank one).}
  \item{\code{setValue(r, c, rawValue=NULL, formattedValue=NULL)}}{Set the
  value of a cell.}
  \item{\code{setRow(rowNumber=NULL, startAtColumnNumber=1, cellTypes=NULL,
  rawValues=NULL, formattedValues=NULL, formats=NULL, visiblity=TRUE,
  baseStyleNames=NULL)}}{Set multiple cells across a row at once.}
  \item{\code{setColumn(columnNumber=NULL, startAtRowNumber=1,
  cellTypes=NULL, rawValues=NULL, formattedValues=NULL, formats=NULL,
  visiblity=TRUE, baseStyleNames=NULL)}}{Set multiple cells down a column at
  once.}
  \item{\code{extendCells(rowCount=NULL, columnCount=NULL)}}{.}
  \item{\code{moveCell(r, c, cell))}}{Move the cell to the specified row
  and column coordinates in the table.}
  \item{\code{insertRow(rowNumber, insertBlankCells=TRUE, headerCells=1,
  totalCells=0)}}{Insert a new row (moving the rows underneath down), where
  headerCells and totalCells control default styling.}
  \item{\code{deleteRow(rowNumber=NULL)}}{Delete a row (moving the rows
  underneath up.}
  \item{\code{insertColumn(columnNumber, insertBlankCells=TRUE,
  headerCells=1, totalCells=0)}}{Insert a new column (moving other columns
  rightwards, where headerCells and totalCells control default styling.}
  \item{\code{deleteColumn(columnNumber=NULL)}}{Delete a column (moving other
  columns leftwards.}
  \item{\code{getCells(specifyCellsAsList=FALSE, rowNumbers=NULL,
  columnNumbers=NULL, cellCoordinates=NULL)}}{Retrieve cells by a combination
  of row and/or column numbers.}
  \item{\code{findCells(rowNumbers=NULL, columnNumbers=NULL, minValue=NULL,
  maxValue=NULL, exactValues=NULL, includeNull=TRUE, includeNA=TRUE)}}{Find
  cells matching the specified criteria.}
  \item{\code{getColumnWidths())}}{Retrieve the width of the longest value
  (in characters) in each column.}
  \item{\code{asList())}}{Get a list representation of the table
  cells.}
  \item{\code{asJSON()}}{Get a JSON representation of the table cells.}
}
}

\examples{
# This class should only be created by the table.
# It is not intended to be created outside of the table.
library(basictabler)
tbl <- qtbl(data.frame(a=1:2, b=3:4))
cells <- tbl$cells
cells$setCell(r=4, c=1, cellType="cell", rawValue=5)
cells$setCell(r=4, c=2, cellType="cell", rawValue=6)
tbl$renderTable()
}
\keyword{datasets}
