% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableOpenXlsxStyles.R
\docType{class}
\name{TableOpenXlsxStyles}
\alias{TableOpenXlsxStyles}
\title{A class that defines a collection of Excel styles as used by the openxlsx
package.}
\format{\code{\link{R6Class}} object.}
\value{
Object of \code{\link{R6Class}} with properties and methods that
  define styles/a theme for a table.
}
\description{
The TableOpenXlsxStyles class stores a collection of TableTableOpenXlsx style
objects.
}
\section{Fields}{

\describe{
\item{\code{parentTable}}{Owning table.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new set of styles, specifying the field
  values documented above.}

  \item{\code{findNamedStyle(baseStyleName)}}{Find an existing openxlsx style
  matching the name of a base style.}
  \item{\code{findOrAddStyle(action="findOrAdd", baseStyleName=NULL,
  isBaseStyle=NULL, style=NULL, mapFromCss=TRUE)}}{Find an existing openxlsx
  style and/or add a new openxlsx style matching a base style and/or
  TableStyle object.}
  \item{\code{addNamedStyles(mapFromCss=TRUE)}}{Populate the OpenXlsx styles
  based on the styles defined in the table.}
  \item{\code{asList()}}{Get a list representation of the styles.}
  \item{\code{asJSON()}}{Get a JSON representation of the styles.}
  \item{\code{asString()}}{Get a text representation of the styles.}
}
}

\examples{
# This class should not be used by end users.  It is an internal class
# created only by the BasicTable class.  It is used when rendering to Excel.
library(basictabler)
tbl <- qtbl(data.frame(a=1:2, b=3:4))
library(openxlsx)
wb <- createWorkbook(creator = Sys.getenv("USERNAME"))
addWorksheet(wb, "Data")
tbl$writeToExcelWorksheet(wb=wb, wsName="Data",
                         topRowNumber=1, leftMostColumnNumber=1,
                         applyStyles=TRUE, mapStylesFromCSS=TRUE)
# Use saveWorkbook() to save the Excel file.
}
