\name{estvssamp}
\alias{estvssamp}
\title{Create a plot that shows how Monte Carlo estimates change with increasing sample size.}
\usage{
  estvssamp(x, fun = mean,
    main = "Estimates vs Sample Size", add = FALSE, ...)
}
\arguments{
  \item{x}{a sample vector.}

  \item{fun}{a function such that \eqn{E(fun(x))} is the
  quantity of interest. The default is \code{fun =
  \link{mean}}.}

  \item{main}{an overall title for the plot. The default is
  \code{"Estimates vs Sample Size"}.}

  \item{add}{logical. If \code{TRUE}, add to a current
  plot.}

  \item{\dots}{additional arguments to the plotting
  function.}
}
\value{
  \code{NULL}
}
\description{
  Create a plot that shows how Monte Carlo estimates change
  with increasing sample size.
}
\examples{
\dontrun{
estvssamp(x, main = expression(E(beta)))
estvssamp(y, add = TRUE, lty = 2, col = "red")}
}

