% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctionsInteractive.R
\name{makeClusterFunctionsInteractive}
\alias{makeClusterFunctionsInteractive}
\title{ClusterFunctions for Sequential Execution in the Running R Session}
\usage{
makeClusterFunctionsInteractive(external = FALSE, write.logs = TRUE)
}
\arguments{
\item{external}{[\code{logical(1)}]\cr
If set to \code{TRUE}, jobs are started in a fresh R session instead of currently active but still
waits for its termination.
Default is \code{FALSE}.}

\item{write.logs}{[\code{logical(1)}]\cr
Sink the output to log files. Turning logging off can increase the speed of
calculations but makes it very difficult to debug.
Default is \code{TRUE}.}
}
\value{
[\code{\link{ClusterFunctions}}].
}
\description{
All jobs are executed sequentially using the current R process in which \code{\link{submitJobs}} is called.
Thus, \code{submitJob} blocks the session until the job has finished.
The main use of this \code{ClusterFunctions} implementation is to test and debug programs on a local computer.

Listing jobs returns an empty vector (as no jobs can be running when you call this)
and \code{killJob} is not implemented for the same reasons.
}
\seealso{
Other ClusterFunctions: \code{\link{makeClusterFunctionsDocker}},
  \code{\link{makeClusterFunctionsLSF}},
  \code{\link{makeClusterFunctionsMulticore}},
  \code{\link{makeClusterFunctionsOpenLava}},
  \code{\link{makeClusterFunctionsSGE}},
  \code{\link{makeClusterFunctionsSSH}},
  \code{\link{makeClusterFunctionsSlurm}},
  \code{\link{makeClusterFunctionsSocket}},
  \code{\link{makeClusterFunctionsTorque}},
  \code{\link{makeClusterFunctions}}
}

