context("addProblem")

test_that("addProblem", {
  reg = makeExperimentRegistry(file.dir = NA, make.default = FALSE)
  prob = addProblem(reg = reg, "p1", data = iris, fun = function(job, data, ...) nrow(data))
  expect_is(prob, "Problem")
  expect_equal(prob$data, iris)
  expect_equal(prob$name, "p1")
  expect_function(prob$fun)
  expect_null(prob$seed)
  expect_file(getProblemURI(reg, prob$name))

  prob = addProblem(reg = reg, "p2", fun = function(...) NULL, seed = 42)
  expect_is(prob, "Problem")
  expect_null(prob$data, NULL)
  expect_equal(prob$name, "p2")
  expect_function(prob$fun)
  expect_identical(prob$seed, 42L)
  expect_file(getProblemURI(reg, prob$name))

  algo = addAlgorithm(reg = reg, "a1", fun = function(job, data, instance, ...) NULL)
  prob.designs = list(p1 = data.table(), p2 = data.table())
  algo.designs = list(a1 = data.table())
  ids = addExperiments(prob.designs, algo.designs, repls = 2, reg = reg)
  expect_integer(ids$job.id, len = 4L)

  removeProblems(reg = reg, "p1")
  expect_integer(reg$status$job.id, len = 2L)
  expect_set_equal(levels(reg$defs$problem), "p2")
  expect_set_equal(getProblemIds(reg), "p2")
  expect_false(file.exists(getProblemURI(reg, "p1")))
  expect_true(file.exists(getProblemURI(reg, "p2")))
  expect_set_equal(as.character(getJobPars(reg = reg)$problem), "p2")
  checkTables(reg)
})
