% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waitForJobs.R
\name{waitForJobs}
\alias{waitForJobs}
\title{Wait for Termination of Jobs}
\usage{
waitForJobs(ids = NULL, sleep = default.sleep, timeout = 604800,
  stop.on.error = FALSE, reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to the return value of \code{\link{findSubmitted}}.
Invalid ids are ignored.}

\item{sleep}{[\code{function(i)} | \code{numeric(1)}]\cr
Function which returns the duration to sleep in the \code{i}-th iteration.
Alternatively, you can pass a single positive numeric value.}

\item{timeout}{[\code{numeric(1)}]\cr
After waiting \code{timeout} seconds, show a message and return
\code{FALSE}. This argument may be required on some systems where, e.g.,
expired jobs or jobs on hold are problematic to detect. If you don't want
a timeout, set this to \code{Inf}. Default is \code{604800} (one week).}

\item{stop.on.error}{[\code{logical(1)}]\cr
Immediately cancel if a job terminates with an error? Default is
\code{FALSE}.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{logical(1)}]. Returns \code{TRUE} if all jobs terminated
  successfully and \code{FALSE} if either the timeout is reached or at least
  one job terminated with an exception.
}
\description{
This function simply waits until all jobs are terminated.
}
