% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_class.R
\docType{class}
\name{linear_class-class}
\alias{linear_class-class}
\alias{linear_class}
\title{linear_class}
\description{
An S4 class for storing results of normal linear model.

\strong{Functions}

summary(`linear_class`): prints a summary of the fit.

print(`linear_class`): prints a more detailed summary of the fit

show(`linear_class`): prints a more detailed summary of the fit.

get_parameters(`linear_class`): returns a dataframe with values of fitted parameters.

get_subject_parameters(`linear_class`): returns a dataframe with values of fitted parameters for each subject in the hierarchical model.

compare_means(`linear_class`, fit2=`linear_class`): prints difference in slope and intercept between two groups. You can also provide the rope parameter.

plot_means_difference(`linear_class`, fit2=`linear_class`): a visualization of the difference between two groups. You can plot only slope or intercept by using the par parameter. You can also provide the rope and bins (number of bins in the histogram) parameters.

plot_means(`linear_class`): plots density of means. You can plot only slope or intercept by using the par parameter.

plot_means(`linear_class`, fit2=`linear_class`): plots density for the first and the second group means. You can plot only slope or intercept by using the par parameter.

compare_distributions(`linear_class`, fit2=`linear_class`): draws samples from distribution of the first group and compares them against samples drawn from the distribution of the second group.

plot_distributions(`linear_class`): a visualization of the fitted distribution.

plot_distributions(`linear_class`, fit2=`linear_class`): a visualization of two fitted distribution.

plot_distributions_difference(`linear_class`, fit2=`linear_class`): a visualization of the difference between the distribution of the first group and the second group. You can plot only slope or intercept by using the par parameter. You can also provide the rope and bins (number of bins in the histogram) parameters.

plot_fit(`linear_class`): plots fitted model against the data. Use this function to explore the quality of your fit. Fit will be plotted on the subject level.

plot_fit(`linear_class`, subjects='boolean'): plots fitted model against the data. Use this function to explore the quality of your fit. You can plot on the subject level (subjects=TRUE) or on the subjects level (subjects=FALSE).

plot_trace(`linear_class`): traceplot for main fitted model parameters.
}
\section{Slots}{

\describe{
\item{\code{extract}}{Extract from Stan fit.}

\item{\code{fit}}{Stan fit.}

\item{\code{data}}{Raw data for the tested group.}
}}

\examples{
\donttest{
# priors
mu_prior <- b_prior(family="normal", pars=c(0, 100))
sigma_prior <- b_prior(family="uniform", pars=c(0, 500))

# attach priors to relevant parameters
priors <- list(c("mu_a", mu_prior),
               c("sigma_a", sigma_prior),
               c("mu_b", mu_prior),
               c("sigma_b", sigma_prior),
               c("mu_s", sigma_prior),
               c("sigma_s", sigma_prior))


# generate data and fit
x <- vector()
y <- vector()
s <- vector()
for (i in 1:5) {
  x <- c(x, rep(1:10, 2))
  y <- c(y, rnorm(20, mean=1:10, sd=2))
  s <- c(s, rep(i, 20))
}

fit1 <- b_linear(x=x, y=y, s=s, priors=priors, chains=1)

fit2 <- b_linear(x=x, y=-2*y, s=s, priors=priors, chains=1)

# a short summary of fitted parameters
summary(fit1)

# a more detailed summary of fitted parameters
print(fit1)
show(fit1)

# extract parameter values from the fit
parameters <- get_parameters(fit1)

# extract parameter values on the bottom (subject) level from the fit
subject_parameters <- get_subject_parameters(fit1)

# compare means between two fits
compare_means(fit1, fit2=fit2)

# compare means between two fits, use a rope interval for intercept and slope
compare_means(fit1, fit2=fit2, rope_intercept=0.5, rope_slope=0.2)

# visualize difference in means between two fits
plot_means_difference(fit1, fit2=fit2)

# visualize difference in means between two fits,
# use a rope interval for intercept and slope,
# set the number of bins in the histogram
plot_means_difference(fit1, fit2=fit2, rope_intercept=0.5, rope_slope=0.2, bins=20)

# visualize difference in means between two fits, compare only slope
plot_means_difference(fit1, fit2=fit2, par="slope")

# visualize means of a single fit
plot_means(fit1)

# visualize means of two fits
plot_means(fit1, fit2=fit2)

# visualize means of two fits, plot slope only
plot_means(fit1, fit2=fit2, par="slope")

# draw samples from distributions underlying two fits and compare them,
# use a rope interval for intercept and slope
compare_distributions(fit1, fit2=fit2, rope_intercept=0.5, rope_slope=0.2)

# visualize the distribution underlying a fit
plot_distributions(fit1)

# visualize distributions underlying two fits
plot_distributions(fit1, fit2=fit2)

# visualize distributions underlying two fits, plot slope only
plot_distributions(fit1, fit2=fit2, par="slope")

# visualize difference between distributions underlying two fits
plot_distributions_difference(fit1, fit2=fit2)

# visualize difference between distributions underlying two fits,
# use a rope interval for intercept and slope,
# set the number of bins in the histogram
plot_distributions_difference(fit1, fit2=fit2, rope_intercept=0.5, rope_slope=0.2, bins=20)

# visualize difference between distributions underlying two fits, plot slope only
plot_distributions_difference(fit1, fit2=fit2, par="slope")

# plot the fitted distribution against the data
plot_fit(fit1)

# plot the fitted distribution against the data,
# plot on the top (group) level
plot_fit(fit1, subjects=FALSE)

# traceplot of the fitted parameters
plot_trace(fit1)
}

}
